/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.foundation.tileEntity.renderer.SmartTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class FunnelRenderer
extends SmartTileEntityRenderer<FunnelTileEntity> {
    public FunnelRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(FunnelTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (!te.hasFlap()) {
            return;
        }
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        SuperByteBuffer flapBuffer = AllBlockPartials.BELT_FUNNEL_FLAP.renderOn(te.func_195044_w());
        Vector3d pivot = VecHelper.voxelSpace(0.0, 10.0, 9.5);
        MatrixStacker msr = MatrixStacker.of(ms);
        float horizontalAngle = AngleHelper.horizontalAngle(FunnelBlock.getFunnelFacing(te.func_195044_w()).func_176734_d());
        float f = te.flap.get(partialTicks);
        ms.func_227860_a_();
        msr.centre().rotateY(horizontalAngle).unCentre();
        ms.func_227861_a_(0.0, 0.0, (double)(-te.getFlapOffset()));
        for (int segment = 0; segment <= 3; ++segment) {
            ms.func_227860_a_();
            float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
            float abs = Math.abs(f);
            float flapAngle = MathHelper.func_76126_a((float)((float)((double)(1.0f - abs) * Math.PI * (double)intensity))) * 30.0f * -f;
            if (f > 0.0f) {
                flapAngle *= 0.5f;
            }
            msr.translate(pivot).rotateX(flapAngle).translateBack(pivot);
            flapBuffer.light(light).renderInto(ms, vb);
            ms.func_227865_b_();
            ms.func_227861_a_(-0.1875, 0.0, 0.0);
        }
        ms.func_227865_b_();
    }
}

