/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.funnel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.DirectionHelper;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;

public class FunnelFilterSlotPositioning
extends ValueBoxTransform.Sided {
    @Override
    protected Vector3d getLocalOffset(BlockState state) {
        Direction side = this.getSide();
        float horizontalAngle = AngleHelper.horizontalAngle(side);
        Direction funnelFacing = FunnelBlock.getFunnelFacing(state);
        float stateAngle = AngleHelper.horizontalAngle(funnelFacing);
        if (state.func_177230_c() instanceof BeltFunnelBlock) {
            switch ((BeltFunnelBlock.Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE))) {
                case EXTENDED: {
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 15.5, 13.0), stateAngle, Direction.Axis.Y);
                }
                case PULLING: 
                case PUSHING: {
                    return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 12.1, 8.7f), horizontalAngle, Direction.Axis.Y);
                }
            }
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 13.0, 7.5), horizontalAngle, Direction.Axis.Y);
        }
        if (!funnelFacing.func_176740_k().func_176722_c()) {
            Vector3d southLocation = VecHelper.voxelSpace(8.0, funnelFacing == Direction.DOWN ? 3.0 : 13.0, 15.5);
            return VecHelper.rotateCentered(southLocation, horizontalAngle, Direction.Axis.Y);
        }
        Direction verticalDirection = DirectionHelper.rotateAround(this.getSide(), funnelFacing.func_176746_e().func_176740_k());
        if (funnelFacing.func_176740_k() == Direction.Axis.Z) {
            verticalDirection = verticalDirection.func_176734_d();
        }
        float yRot = -AngleHelper.horizontalAngle(verticalDirection) + 180.0f;
        float xRot = -90.0f;
        boolean alongX = funnelFacing.func_176740_k() == Direction.Axis.X;
        float zRotLast = alongX ^ funnelFacing.func_176743_c() == Direction.AxisDirection.POSITIVE ? 180.0f : 0.0f;
        Vector3d vec = VecHelper.voxelSpace(8.0, 13.0, 0.5);
        vec = vec.func_178786_a(0.5, 0.5, 0.5);
        vec = VecHelper.rotate(vec, zRotLast, Direction.Axis.Z);
        vec = VecHelper.rotate(vec, yRot, Direction.Axis.Y);
        vec = VecHelper.rotate(vec, alongX ? 0.0 : (double)xRot, Direction.Axis.X);
        vec = VecHelper.rotate(vec, alongX ? (double)xRot : 0.0, Direction.Axis.Z);
        vec = vec.func_72441_c(0.5, 0.5, 0.5);
        return vec;
    }

    @Override
    protected void rotate(BlockState state, MatrixStack ms) {
        Direction facing = FunnelBlock.getFunnelFacing(state);
        if (facing.func_176740_k().func_200128_b()) {
            super.rotate(state, ms);
            return;
        }
        boolean isBeltFunnel = state.func_177230_c() instanceof BeltFunnelBlock;
        if (isBeltFunnel && state.func_177229_b(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.EXTENDED) {
            BeltFunnelBlock.Shape shape = (BeltFunnelBlock.Shape)((Object)state.func_177229_b(BeltFunnelBlock.SHAPE));
            super.rotate(state, ms);
            if (shape == BeltFunnelBlock.Shape.PULLING || shape == BeltFunnelBlock.Shape.PUSHING) {
                MatrixStacker.of(ms).rotateX(-22.5);
            }
            return;
        }
        Direction verticalDirection = DirectionHelper.rotateAround(this.getSide(), facing.func_176746_e().func_176740_k());
        if (facing.func_176740_k() == Direction.Axis.Z) {
            verticalDirection = verticalDirection.func_176734_d();
        }
        float yRot = -AngleHelper.horizontalAngle(verticalDirection) + 180.0f;
        float xRot = -90.0f;
        boolean alongX = facing.func_176740_k() == Direction.Axis.X;
        float zRotLast = alongX ^ facing.func_176743_c() == Direction.AxisDirection.POSITIVE ? 180.0f : 0.0f;
        MatrixStacker.of(ms).rotateZ(alongX ? (double)xRot : 0.0).rotateX(alongX ? 0.0 : (double)xRot).rotateY(yRot).rotateZ(zRotLast);
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction facing = FunnelBlock.getFunnelFacing(state);
        if (facing == null) {
            return false;
        }
        if (state.func_177230_c() instanceof BeltFunnelBlock) {
            return state.func_177229_b(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.EXTENDED ? direction == facing : direction == Direction.UP;
        }
        return direction.func_176740_k() != facing.func_176740_k();
    }

    @Override
    protected Vector3d getSouthLocation() {
        return Vector3d.field_186680_a;
    }
}

