/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.particle.AirParticleData;
import com.simibubi.create.content.logistics.block.chute.ChuteBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteItemHandler;
import com.simibubi.create.content.logistics.block.funnel.BrassFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.widgets.InterpolatedValue;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChuteTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    float pull;
    float push;
    ItemStack item = ItemStack.field_190927_a;
    InterpolatedValue itemPosition = new InterpolatedValue();
    ChuteItemHandler itemHandler = new ChuteItemHandler(this);
    LazyOptional<IItemHandler> lazyHandler = LazyOptional.of(() -> this.itemHandler);
    boolean canPickUpItems = false;
    float bottomPullDistance = 0.0f;
    float beltBelowOffset;
    TransportedItemStackHandlerBehaviour beltBelow;
    boolean updateAirFlow = true;
    int airCurrentUpdateCooldown;
    int entitySearchCooldown;
    LazyOptional<IItemHandler> capAbove = LazyOptional.empty();
    LazyOptional<IItemHandler> capBelow = LazyOptional.empty();

    public ChuteTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(d -> this.canDirectlyInsertCached()));
    }

    public boolean canDirectlyInsertCached() {
        return this.canPickUpItems;
    }

    private boolean canDirectlyInsert() {
        BlockState blockState = this.func_195044_w();
        BlockState blockStateAbove = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (!AllBlocks.CHUTE.has(blockState)) {
            return false;
        }
        if (AllBlocks.CHUTE.has(blockStateAbove) && blockStateAbove.func_177229_b((Property)ChuteBlock.FACING) == Direction.DOWN) {
            return false;
        }
        if (this.getItemMotion() > 0.0f && this.getInputChutes().isEmpty()) {
            return false;
        }
        return blockState.func_177229_b((Property)ChuteBlock.FACING) == Direction.DOWN || blockState.func_177229_b(ChuteBlock.SHAPE) == ChuteBlock.Shape.INTERSECTION;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.onAdded();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(0.0, -3.0, 0.0);
    }

    @Override
    public void func_73660_a() {
        float itemMotion;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.canPickUpItems = this.canDirectlyInsert();
        }
        if ((itemMotion = this.getItemMotion()) != 0.0f && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.spawnParticles(itemMotion);
        }
        this.tickAirStreams(itemMotion);
        if (this.item.func_190926_b()) {
            if (itemMotion < 0.0f) {
                this.handleInputFromAbove();
            }
            if (itemMotion > 0.0f) {
                this.handleInputFromBelow();
            }
            return;
        }
        float nextOffset = this.itemPosition.value + itemMotion;
        if (itemMotion < 0.0f && nextOffset < 0.5f) {
            if (!this.handleDownwardOutput(true)) {
                nextOffset = 0.5f;
            } else if (nextOffset < 0.0f) {
                this.handleDownwardOutput(this.field_145850_b.field_72995_K);
                return;
            }
        }
        if (itemMotion > 0.0f && nextOffset > 0.5f) {
            if (!this.handleUpwardOutput(true)) {
                nextOffset = 0.5f;
            } else if (nextOffset > 1.0f) {
                this.handleUpwardOutput(this.field_145850_b.field_72995_K);
                return;
            }
        }
        this.itemPosition.set(nextOffset);
    }

    private void updateAirFlow(float itemSpeed) {
        this.updateAirFlow = false;
        if (itemSpeed > 0.0f && this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            float flowLimit;
            float speed = this.pull - this.push;
            this.beltBelow = null;
            float maxPullDistance = speed >= 128.0f ? 3.0f : (speed >= 64.0f ? 2.0f : (speed >= 32.0f ? 1.0f : MathHelper.func_219799_g((float)(speed / 32.0f), (float)0.0f, (float)1.0f)));
            if (AllBlocks.CHUTE.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
                maxPullDistance = 0.0f;
            }
            if ((flowLimit = maxPullDistance) > 0.0f) {
                flowLimit = AirCurrent.getFlowLimit(this.field_145850_b, this.field_174879_c, maxPullDistance, Direction.DOWN);
            }
            int i = 1;
            while ((float)i <= flowLimit + 1.0f) {
                TransportedItemStackHandlerBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177979_c(i), TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour != null) {
                    this.beltBelow = behaviour;
                    this.beltBelowOffset = i - 1;
                    break;
                }
                ++i;
            }
            this.bottomPullDistance = flowLimit;
        }
        this.sendData();
    }

    private void findEntities(float itemSpeed) {
        block1: {
            if (this.bottomPullDistance <= 0.0f && !this.getItem().func_190926_b() || itemSpeed <= 0.0f || this.field_145850_b == null || this.field_145850_b.field_72995_K) {
                return;
            }
            Vector3d center = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
            AxisAlignedBB searchArea = new AxisAlignedBB(center.func_72441_c(0.0, (double)(-this.bottomPullDistance) - 0.5, 0.0), center.func_72441_c(0.0, -0.5, 0.0)).func_186662_g((double)0.45f);
            Iterator iterator = this.field_145850_b.func_217357_a(ItemEntity.class, searchArea).iterator();
            if (!iterator.hasNext()) break block1;
            ItemEntity itemEntity = (ItemEntity)iterator.next();
            this.setItem(itemEntity.func_92059_d().func_77946_l(), (float)(itemEntity.func_174813_aQ().func_189972_c().field_72448_b - (double)this.field_174879_c.func_177956_o()));
            itemEntity.func_70106_y();
            AllTriggers.triggerForNearbyPlayers(AllTriggers.UPWARD_CHUTE, (IWorld)this.field_145850_b, this.field_174879_c, 5);
        }
    }

    private void extractFromBelt(float itemSpeed) {
        if (itemSpeed <= 0.0f || this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getItem().func_190926_b() && this.beltBelow != null) {
            this.beltBelow.handleCenteredProcessingOnAllItems(0.5f, ts -> {
                if (this.getItem().func_190926_b()) {
                    this.setItem(ts.stack.func_77946_l(), -this.beltBelowOffset);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    private void tickAirStreams(float itemSpeed) {
        if (!this.field_145850_b.field_72995_K && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow(itemSpeed);
        }
        if (this.entitySearchCooldown-- <= 0 && this.item.func_190926_b()) {
            this.entitySearchCooldown = 5;
            this.findEntities(itemSpeed);
        }
        this.extractFromBelt(itemSpeed);
    }

    public void blockBelowChanged() {
        this.updateAirFlow = true;
    }

    private void spawnParticles(float itemMotion) {
        float absMotion;
        if (this.field_145850_b == null) {
            return;
        }
        BlockState blockState = this.func_195044_w();
        boolean up = itemMotion > 0.0f;
        float f = absMotion = up ? itemMotion : -itemMotion;
        if (blockState == null || !(blockState.func_177230_c() instanceof ChuteBlock)) {
            return;
        }
        if (this.push == 0.0f && this.pull == 0.0f) {
            return;
        }
        if (up && (blockState.func_177229_b((Property)ChuteBlock.FACING) == Direction.DOWN || blockState.func_177229_b(ChuteBlock.SHAPE) == ChuteBlock.Shape.INTERSECTION) && BlockHelper.noCollisionInSpace((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a())) {
            this.spawnAirFlow(1.0f, 2.0f, absMotion, 0.5f);
        }
        if (blockState.func_177229_b((Property)ChuteBlock.FACING) != Direction.DOWN) {
            return;
        }
        if (blockState.func_177229_b(ChuteBlock.SHAPE) == ChuteBlock.Shape.WINDOW) {
            this.spawnAirFlow(up ? 0.0f : 1.0f, up ? 1.0f : 0.0f, absMotion, 1.0f);
        }
        if (!up && BlockHelper.noCollisionInSpace((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b())) {
            this.spawnAirFlow(0.0f, -1.0f, absMotion, 0.5f);
        }
        if (up && this.bottomPullDistance > 0.0f) {
            this.spawnAirFlow(-this.bottomPullDistance, 0.0f, absMotion, 2.0f);
            this.spawnAirFlow(-this.bottomPullDistance, 0.0f, absMotion, 2.0f);
        }
    }

    private void spawnAirFlow(float verticalStart, float verticalEnd, float motion, float drag) {
        if (this.field_145850_b == null) {
            return;
        }
        AirParticleData airParticleData = new AirParticleData(drag, motion);
        Vector3d origin = Vector3d.func_237491_b_((Vector3i)this.field_174879_c);
        float xOff = Create.random.nextFloat() * 0.5f + 0.25f;
        float zOff = Create.random.nextFloat() * 0.5f + 0.25f;
        Vector3d v = origin.func_72441_c((double)xOff, (double)verticalStart, (double)zOff);
        Vector3d d = origin.func_72441_c((double)xOff, (double)verticalEnd, (double)zOff).func_178788_d(v);
        if (Create.random.nextFloat() < 2.0f * motion) {
            this.field_145850_b.func_195589_b((IParticleData)airParticleData, v.field_72450_a, v.field_72448_b, v.field_72449_c, d.field_72450_a, d.field_72448_b, d.field_72449_c);
        }
    }

    private void handleInputFromAbove() {
        if (!this.capAbove.isPresent()) {
            this.capAbove = this.grabCapability(Direction.UP);
        }
        if (this.capAbove.isPresent()) {
            this.item = ItemHelper.extract((IItemHandler)this.capAbove.orElse(null), stack -> true, ItemHelper.ExtractionCountMode.UPTO, 16, false);
        }
    }

    private void handleInputFromBelow() {
        if (!this.capBelow.isPresent()) {
            this.capBelow = this.grabCapability(Direction.DOWN);
        }
        if (this.capBelow.isPresent()) {
            this.item = ItemHelper.extract((IItemHandler)this.capBelow.orElse(null), stack -> true, ItemHelper.ExtractionCountMode.UPTO, 16, false);
        }
    }

    private boolean handleDownwardOutput(boolean simulate) {
        BlockState blockState = this.func_195044_w();
        ChuteTileEntity targetChute = this.getTargetChute(blockState);
        Direction direction = (Direction)blockState.func_177229_b((Property)ChuteBlock.FACING);
        if (targetChute != null) {
            boolean canInsert = targetChute.item.func_190926_b();
            if (!simulate && canInsert) {
                targetChute.setItem(this.item, direction == Direction.DOWN ? 1.0f : 0.51f);
                this.setItem(ItemStack.field_190927_a);
            }
            return canInsert;
        }
        if (this.field_145850_b == null || direction.func_176740_k().func_176722_c()) {
            return false;
        }
        BlockState stateBelow = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (stateBelow.func_177230_c() instanceof FunnelBlock) {
            if (stateBelow.func_235903_d_((Property)BrassFunnelBlock.POWERED).orElse(false).booleanValue()) {
                return false;
            }
            if (stateBelow.func_177229_b((Property)BrassFunnelBlock.field_176387_N) != Direction.UP) {
                return false;
            }
            ItemStack remainder = FunnelBlock.tryInsert(this.field_145850_b, this.field_174879_c.func_177977_b(), this.item, simulate);
            if (!simulate) {
                this.setItem(remainder);
            }
            return remainder.func_190926_b();
        }
        DirectBeltInputBehaviour directInput = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), DirectBeltInputBehaviour.TYPE);
        if (directInput != null) {
            if (!directInput.canInsertFromSide(Direction.UP)) {
                return false;
            }
            ItemStack remainder = directInput.handleInsertion(this.item, Direction.UP, simulate);
            if (!simulate) {
                this.setItem(remainder);
            }
            return remainder.func_190926_b();
        }
        if (!this.capBelow.isPresent()) {
            this.capBelow = this.grabCapability(Direction.DOWN);
        }
        if (this.capBelow.isPresent()) {
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.capBelow.orElse(null)), (ItemStack)this.item, (boolean)simulate);
            if (!simulate) {
                this.setItem(ItemStack.field_190927_a);
            }
            return remainder.func_190926_b();
        }
        if (Block.func_220064_c((IBlockReader)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b())) {
            return false;
        }
        if (!simulate) {
            Vector3d dropVec = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_72441_c(0.0, -0.75, 0.0);
            ItemEntity dropped = new ItemEntity(this.field_145850_b, dropVec.field_72450_a, dropVec.field_72448_b, dropVec.field_72449_c, this.item.func_77946_l());
            dropped.func_174869_p();
            dropped.func_213293_j(0.0, -0.25, 0.0);
            this.field_145850_b.func_217376_c((Entity)dropped);
            this.setItem(ItemStack.field_190927_a);
        }
        return true;
    }

    private boolean handleUpwardOutput(boolean simulate) {
        ItemStack remainder;
        boolean powered;
        BlockState stateAbove = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (stateAbove.func_177230_c() instanceof FunnelBlock && !(powered = stateAbove.func_235903_d_((Property)BrassFunnelBlock.POWERED).orElse(false).booleanValue()) && stateAbove.func_177229_b((Property)BrassFunnelBlock.field_176387_N) == Direction.DOWN && (remainder = FunnelBlock.tryInsert(this.field_145850_b, this.field_174879_c.func_177984_a(), this.item, simulate)).func_190926_b()) {
            if (!simulate) {
                this.setItem(remainder);
            }
            return true;
        }
        ChuteTileEntity bestOutput = null;
        List<ChuteTileEntity> inputChutes = this.getInputChutes();
        for (ChuteTileEntity targetChute : inputChutes) {
            float itemMotion;
            if (!targetChute.item.func_190926_b() || (itemMotion = targetChute.getItemMotion()) < 0.0f || bestOutput != null && !(bestOutput.getItemMotion() < itemMotion)) continue;
            bestOutput = targetChute;
        }
        if (bestOutput != null) {
            if (!simulate) {
                bestOutput.setItem(this.item, 0.0f);
                this.setItem(ItemStack.field_190927_a);
            }
            return true;
        }
        if (!this.capAbove.isPresent()) {
            this.capAbove = this.grabCapability(Direction.UP);
        }
        if (this.capAbove.isPresent()) {
            ItemStack remainder2 = ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.capAbove.orElse(null)), (ItemStack)this.item, (boolean)simulate);
            if (!simulate) {
                this.setItem(ItemStack.field_190927_a);
            }
            return remainder2.func_190926_b();
        }
        if (BlockHelper.hasBlockSolidSide(stateAbove, (IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a(), Direction.DOWN)) {
            return false;
        }
        if (!inputChutes.isEmpty()) {
            return false;
        }
        if (!simulate) {
            Vector3d dropVec = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_72441_c(0.0, 0.5, 0.0);
            ItemEntity dropped = new ItemEntity(this.field_145850_b, dropVec.field_72450_a, dropVec.field_72448_b, dropVec.field_72449_c, this.item.func_77946_l());
            dropped.func_174869_p();
            dropped.func_213293_j(0.0, (double)(this.getItemMotion() * 2.0f), 0.0);
            this.field_145850_b.func_217376_c((Entity)dropped);
            this.setItem(ItemStack.field_190927_a);
        }
        return true;
    }

    private LazyOptional<IItemHandler> grabCapability(Direction side) {
        BlockPos pos = this.field_174879_c.func_177972_a(side);
        if (this.field_145850_b == null) {
            return LazyOptional.empty();
        }
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te == null || te instanceof ChuteTileEntity) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
    }

    public void setItem(ItemStack stack) {
        this.setItem(stack, this.getItemMotion() < 0.0f ? 1.0f : 0.0f);
    }

    public void setItem(ItemStack stack, float insertionPos) {
        this.item = stack;
        this.itemPosition.lastValue = this.itemPosition.value = insertionPos;
        this.func_70296_d();
        this.sendData();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.lazyHandler != null) {
            this.lazyHandler.invalidate();
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_218657_a("Item", (INBT)this.item.serializeNBT());
        compound.func_74776_a("ItemPosition", this.itemPosition.value);
        compound.func_74776_a("Pull", this.pull);
        compound.func_74776_a("Push", this.push);
        compound.func_74776_a("BottomAirFlowDistance", this.bottomPullDistance);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        ItemStack previousItem = this.item;
        this.item = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Item"));
        this.itemPosition.lastValue = this.itemPosition.value = compound.func_74760_g("ItemPosition");
        this.pull = compound.func_74760_g("Pull");
        this.push = compound.func_74760_g("Push");
        this.bottomPullDistance = compound.func_74760_g("BottomAirFlowDistance");
        super.fromTag(state, compound, clientPacket);
        if (this.func_145830_o() && this.field_145850_b != null && this.field_145850_b.field_72995_K && !previousItem.equals(this.item, false) && !this.item.func_190926_b()) {
            if (this.field_145850_b.field_73012_v.nextInt(3) != 0) {
                return;
            }
            Vector3d p = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
            p = VecHelper.offsetRandomly(p, this.field_145850_b.field_73012_v, 0.5f);
            Vector3d m = Vector3d.field_186680_a;
            this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.item), p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
        }
    }

    public float getItemMotion() {
        float fanSpeedModifier = 0.015625f;
        float maxItemSpeed = 20.0f;
        float gravity = 4.0f;
        float motion = (this.push + this.pull) * 0.015625f;
        return (MathHelper.func_76131_a((float)motion, (float)-20.0f, (float)20.0f) + (motion <= 0.0f ? -4.0f : 0.0f)) / 20.0f;
    }

    public void onRemoved(BlockState chuteState) {
        ChuteTileEntity targetChute = this.getTargetChute(chuteState);
        List<ChuteTileEntity> inputChutes = this.getInputChutes();
        if (!this.item.func_190926_b() && this.field_145850_b != null) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.item);
        }
        this.func_145843_s();
        if (targetChute != null) {
            targetChute.updatePull();
            targetChute.propagatePush();
        }
        inputChutes.forEach(c -> c.updatePush(inputChutes.size()));
    }

    public void onAdded() {
        this.func_145836_u();
        this.updatePull();
        ChuteTileEntity targetChute = this.getTargetChute(this.func_195044_w());
        if (targetChute != null) {
            targetChute.propagatePush();
        } else {
            this.updatePush(1);
        }
    }

    public void updatePull() {
        float totalPull = this.calculatePull();
        if (this.pull == totalPull) {
            return;
        }
        this.pull = totalPull;
        this.updateAirFlow = true;
        this.sendData();
        ChuteTileEntity targetChute = this.getTargetChute(this.func_195044_w());
        if (targetChute != null) {
            targetChute.updatePull();
        }
    }

    public void updatePush(int branchCount) {
        float totalPush = this.calculatePush(branchCount);
        if (this.push == totalPush) {
            return;
        }
        this.updateAirFlow = true;
        this.push = totalPush;
        this.sendData();
        this.propagatePush();
    }

    public void propagatePush() {
        List<ChuteTileEntity> inputs = this.getInputChutes();
        inputs.forEach(c -> c.updatePush(inputs.size()));
    }

    protected float calculatePull() {
        TileEntity te;
        BlockState blockStateAbove = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (AllBlocks.ENCASED_FAN.has(blockStateAbove) && blockStateAbove.func_177229_b((Property)EncasedFanBlock.FACING) == Direction.DOWN && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof EncasedFanTileEntity && !te.func_145837_r()) {
            EncasedFanTileEntity fan = (EncasedFanTileEntity)te;
            return fan.getSpeed();
        }
        float totalPull = 0.0f;
        for (Direction d : Iterate.directions) {
            ChuteTileEntity inputChute = this.getInputChute(d);
            if (inputChute == null) continue;
            totalPull += inputChute.pull;
        }
        return totalPull;
    }

    protected float calculatePush(int branchCount) {
        TileEntity te;
        if (this.field_145850_b == null) {
            return 0.0f;
        }
        BlockState blockStateBelow = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (AllBlocks.ENCASED_FAN.has(blockStateBelow) && blockStateBelow.func_177229_b((Property)EncasedFanBlock.FACING) == Direction.UP && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof EncasedFanTileEntity && !te.func_145837_r()) {
            EncasedFanTileEntity fan = (EncasedFanTileEntity)te;
            return fan.getSpeed();
        }
        ChuteTileEntity targetChute = this.getTargetChute(this.func_195044_w());
        if (targetChute == null) {
            return 0.0f;
        }
        return targetChute.push / (float)branchCount;
    }

    @Nullable
    private ChuteTileEntity getTargetChute(BlockState state) {
        BlockState chuteState;
        if (this.field_145850_b == null) {
            return null;
        }
        Direction targetDirection = (Direction)state.func_177229_b((Property)ChuteBlock.FACING);
        BlockPos chutePos = this.field_174879_c.func_177977_b();
        if (targetDirection.func_176740_k().func_176722_c()) {
            chutePos = chutePos.func_177972_a(targetDirection.func_176734_d());
        }
        if (!AllBlocks.CHUTE.has(chuteState = this.field_145850_b.func_180495_p(chutePos))) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(chutePos);
        if (te instanceof ChuteTileEntity) {
            return (ChuteTileEntity)te;
        }
        return null;
    }

    private List<ChuteTileEntity> getInputChutes() {
        LinkedList<ChuteTileEntity> inputs = new LinkedList<ChuteTileEntity>();
        for (Direction d : Iterate.directions) {
            ChuteTileEntity inputChute = this.getInputChute(d);
            if (inputChute == null) continue;
            inputs.add(inputChute);
        }
        return inputs;
    }

    @Nullable
    private ChuteTileEntity getInputChute(Direction direction) {
        BlockState chuteState;
        if (this.field_145850_b == null || direction == Direction.DOWN) {
            return null;
        }
        direction = direction.func_176734_d();
        BlockPos chutePos = this.field_174879_c.func_177984_a();
        if (direction.func_176740_k().func_176722_c()) {
            chutePos = chutePos.func_177972_a(direction);
        }
        if (!AllBlocks.CHUTE.has(chuteState = this.field_145850_b.func_180495_p(chutePos)) || chuteState.func_177229_b((Property)ChuteBlock.FACING) != direction) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(chutePos);
        if (te instanceof ChuteTileEntity && !te.func_145837_r()) {
            return (ChuteTileEntity)te;
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        boolean downward = this.getItemMotion() < 0.0f;
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.chute.header", new Object[0])));
        if (this.pull == 0.0f && this.push == 0.0f) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.chute.no_fans_attached", new Object[0])).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.pull != 0.0f) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.chute.fans_" + (this.pull > 0.0f ? "pull_up" : "push_down"), new Object[0]).func_240699_a_(TextFormatting.GRAY)));
        }
        if (this.push != 0.0f) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.chute.fans_" + (this.push > 0.0f ? "push_up" : "pull_down"), new Object[0]).func_240699_a_(TextFormatting.GRAY)));
        }
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_240702_b_("-> ").func_230529_a_((ITextComponent)Lang.translate("tooltip.chute.items_move_" + (downward ? "down" : "up"), new Object[0]).func_240699_a_(TextFormatting.YELLOW)));
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getItem() {
        return this.item;
    }
}

