/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.logistics.block.chute.ChuteBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class ChuteShapes {
    static Map<BlockState, VoxelShape> cache = new HashMap<BlockState, VoxelShape>();
    static Map<BlockState, VoxelShape> collisionCache = new HashMap<BlockState, VoxelShape>();
    public static final VoxelShape INTERSECTION_MASK = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape COLLISION_MASK = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);
    public static final VoxelShape PANEL = Block.func_208617_a((double)1.0, (double)-15.0, (double)0.0, (double)15.0, (double)4.0, (double)1.0);

    public static VoxelShape createShape(BlockState state) {
        boolean intersection;
        Direction direction = (Direction)state.func_177229_b((Property)ChuteBlock.FACING);
        ChuteBlock.Shape shape = (ChuteBlock.Shape)((Object)state.func_177229_b(ChuteBlock.SHAPE));
        boolean bl = intersection = shape == ChuteBlock.Shape.INTERSECTION;
        if (direction == Direction.DOWN) {
            return intersection ? VoxelShapes.func_197868_b() : AllShapes.CHUTE;
        }
        VoxelShape combineWith = intersection ? VoxelShapes.func_197868_b() : VoxelShapes.func_197880_a();
        VoxelShape result = VoxelShapes.func_197872_a((VoxelShape)combineWith, (VoxelShape)AllShapes.CHUTE_SLOPE.get(direction));
        if (intersection) {
            result = VoxelShapes.func_197882_b((VoxelShape)INTERSECTION_MASK, (VoxelShape)result, (IBooleanFunction)IBooleanFunction.field_223238_i_);
        }
        return result;
    }

    public static VoxelShape getShape(BlockState state) {
        if (cache.containsKey(state)) {
            return cache.get(state);
        }
        VoxelShape createdShape = ChuteShapes.createShape(state);
        cache.put(state, createdShape);
        return createdShape;
    }

    public static VoxelShape getCollisionShape(BlockState state) {
        if (collisionCache.containsKey(state)) {
            return collisionCache.get(state);
        }
        VoxelShape createdShape = VoxelShapes.func_197882_b((VoxelShape)COLLISION_MASK, (VoxelShape)ChuteShapes.getShape(state), (IBooleanFunction)IBooleanFunction.field_223238_i_);
        collisionCache.put(state, createdShape);
        return createdShape;
    }

    public static VoxelShape createSlope() {
        VoxelShape shape = VoxelShapes.func_197880_a();
        for (int i = 0; i < 16; ++i) {
            float offset = (float)i / 16.0f;
            shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)PANEL.func_197751_a(0.0, (double)offset, (double)offset), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }
}

