/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.chute.ChuteShapes;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChuteBlock
extends Block
implements IWrenchable,
ITE<ChuteTileEntity> {
    public static final Property<Shape> SHAPE = EnumProperty.func_177709_a((String)"shape", Shape.class);
    public static final DirectionProperty FACING = BlockStateProperties.field_208156_I;

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CHUTE.create();
    }

    public ChuteBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)Shape.NORMAL))).func_206870_a((Property)FACING, (Comparable)Direction.DOWN));
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        DirectBeltInputBehaviour input = TileEntityBehaviour.get((IBlockReader)entityIn.field_70170_p, new BlockPos(entityIn.func_213303_ch().func_72441_c(0.0, 0.5, 0.0)).func_177977_b(), DirectBeltInputBehaviour.TYPE);
        if (input == null) {
            return;
        }
        if (!input.canInsertFromSide(Direction.UP)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        ItemStack toInsert = itemEntity.func_92059_d();
        ItemStack remainder = input.handleInsertion(toInsert, Direction.UP, false);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        if (remainder.func_190916_E() < toInsert.func_190916_E()) {
            itemEntity.func_92058_a(remainder);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        this.withTileEntityDo((IBlockReader)world, pos, ChuteTileEntity::onAdded);
        if (p_220082_5_) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
    }

    protected void updateDiagonalNeighbour(BlockState state, World world, BlockPos pos) {
        BlockState updated;
        BlockState stateToUpdate;
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos toUpdate = pos.func_177977_b();
        if (facing.func_176740_k().func_176722_c()) {
            toUpdate = toUpdate.func_177972_a(facing.func_176734_d());
        }
        if ((stateToUpdate = world.func_180495_p(toUpdate)) != (updated = ChuteBlock.updateDiagonalState(stateToUpdate, world.func_180495_p(toUpdate.func_177984_a()), (IBlockReader)world, toUpdate)) && !world.field_72995_K) {
            world.func_175656_a(toUpdate, updated);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        boolean differentBlock;
        boolean bl = differentBlock = state.func_177230_c() != p_196243_4_.func_177230_c();
        if (state.hasTileEntity() && (differentBlock || !p_196243_4_.hasTileEntity())) {
            this.withTileEntityDo((IBlockReader)world, pos, c -> c.onRemoved(state));
            world.func_175713_t(pos);
        }
        if (p_196243_5_ || !differentBlock) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
        for (Direction direction : Iterate.horizontalDirections) {
            BlockState updated;
            BlockPos toUpdate = pos.func_177984_a().func_177972_a(direction);
            BlockState stateToUpdate = world.func_180495_p(toUpdate);
            if (stateToUpdate == (updated = ChuteBlock.updateDiagonalState(stateToUpdate, world.func_180495_p(toUpdate.func_177984_a()), (IBlockReader)world, toUpdate)) || world.field_72995_K) continue;
            world.func_175656_a(toUpdate, updated);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState above, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (direction != Direction.UP) {
            return state;
        }
        return ChuteBlock.updateDiagonalState(state, above, (IBlockReader)world, pos);
    }

    public void func_220069_a(BlockState p_220069_1_, World world, BlockPos pos, Block p_220069_4_, BlockPos neighbourPos, boolean p_220069_6_) {
        if (pos.func_177977_b().equals((Object)neighbourPos)) {
            this.withTileEntityDo((IBlockReader)world, pos, ChuteTileEntity::blockBelowChanged);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState above = world.func_180495_p(pos.func_177984_a());
        return !(above.func_177230_c() instanceof ChuteBlock) || above.func_177229_b((Property)FACING) == Direction.DOWN;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState state = super.func_196258_a(ctx);
        Direction face = ctx.func_196000_l();
        if (face.func_176740_k().func_176722_c() && !ctx.func_225518_g_()) {
            World world = ctx.func_195991_k();
            BlockPos pos = ctx.func_195995_a();
            return ChuteBlock.updateDiagonalState((BlockState)state.func_206870_a((Property)FACING, (Comparable)face), world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos);
        }
        return state;
    }

    public static BlockState updateDiagonalState(BlockState state, BlockState above, IBlockReader world, BlockPos pos) {
        boolean noConnections;
        BlockState target;
        boolean vertical;
        if (!(state.func_177230_c() instanceof ChuteBlock)) {
            return state;
        }
        HashMap<BlockState, Boolean> connections = new HashMap<BlockState, Boolean>();
        int amtConnections = 0;
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        boolean bl = vertical = facing == Direction.DOWN;
        if (!vertical && !((target = world.func_180495_p(pos.func_177977_b().func_177972_a(facing.func_176734_d()))).func_177230_c() instanceof ChuteBlock)) {
            return (BlockState)((BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        for (BlockState direction : Iterate.horizontalDirections) {
            BlockState diagonalInputChute = world.func_180495_p(pos.func_177984_a().func_177972_a((Direction)direction));
            boolean value = diagonalInputChute.func_177230_c() instanceof ChuteBlock && diagonalInputChute.func_177229_b((Property)FACING) == direction;
            connections.put(direction, value);
            if (!value) continue;
            ++amtConnections;
        }
        boolean bl2 = noConnections = amtConnections == 0;
        if (vertical) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(noConnections ? (state.func_177229_b(SHAPE) == Shape.WINDOW ? Shape.WINDOW : Shape.NORMAL) : Shape.INTERSECTION)));
        }
        if (noConnections) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.NORTH)).booleanValue() && ((Boolean)connections.get(Direction.SOUTH)).booleanValue()) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (((Boolean)connections.get(Direction.EAST)).booleanValue() && ((Boolean)connections.get(Direction.WEST)).booleanValue()) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
        }
        if (!(amtConnections != 1 || !((Boolean)connections.get(facing)).booleanValue() || above.func_177230_c() instanceof ChuteBlock && above.func_177229_b((Property)FACING) == Direction.DOWN || above.func_177230_c() instanceof FunnelBlock && FunnelBlock.getFunnelFacing(above).func_176740_k().func_200128_b())) {
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.NORMAL));
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.INTERSECTION));
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        boolean down;
        Shape shape = (Shape)((Object)state.func_177229_b(SHAPE));
        boolean bl = down = state.func_177229_b((Property)FACING) == Direction.DOWN;
        if (!context.func_195991_k().field_72995_K && down && shape != Shape.INTERSECTION) {
            context.func_195991_k().func_175656_a(context.func_195995_a(), (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(shape == Shape.WINDOW ? Shape.NORMAL : Shape.WINDOW))));
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return ChuteShapes.getShape(p_220053_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        BlockHelper.addReducedDestroyEffects(state, world, pos, manager);
        return true;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return ChuteShapes.getCollisionShape(p_220071_1_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a(p_206840_1_.func_206894_a(new Property[]{SHAPE, FACING}));
    }

    @Override
    public Class<ChuteTileEntity> getTileEntityClass() {
        return ChuteTileEntity.class;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (!player.func_184586_b(hand).func_190926_b()) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        try {
            ChuteTileEntity te = (ChuteTileEntity)this.getTileEntity((IBlockReader)world, pos);
            if (te == null) {
                return ActionResultType.PASS;
            }
            if (te.item.func_190926_b()) {
                return ActionResultType.PASS;
            }
            player.field_71071_by.func_191975_a(world, te.item);
            te.setItem(ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        catch (ITE.TileEntityException e) {
            e.printStackTrace();
            return ActionResultType.PASS;
        }
    }

    public static enum Shape implements IStringSerializable
    {
        INTERSECTION,
        WINDOW,
        NORMAL;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

