/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BeltTunnelTileEntity
extends SmartTileEntity {
    public HashMap<Direction, InterpolatedChasingValue> flaps;
    public Set<Direction> sides;
    protected LazyOptional<IItemHandler> cap = LazyOptional.empty();
    protected List<Pair<Direction, Boolean>> flapsToSend;

    public BeltTunnelTileEntity(TileEntityType<? extends BeltTunnelTileEntity> type) {
        super(type);
        this.flaps = new HashMap();
        this.sides = new HashSet<Direction>();
        this.flapsToSend = new LinkedList<Pair<Direction, Boolean>>();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.cap.invalidate();
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        ListNBT flapsNBT = new ListNBT();
        for (Direction direction : this.flaps.keySet()) {
            flapsNBT.add((Object)IntNBT.func_229692_a_((int)direction.func_176745_a()));
        }
        compound.func_218657_a("Flaps", (INBT)flapsNBT);
        ListNBT sidesNBT = new ListNBT();
        for (Direction direction : this.sides) {
            sidesNBT.add((Object)IntNBT.func_229692_a_((int)direction.func_176745_a()));
        }
        compound.func_218657_a("Sides", (INBT)sidesNBT);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        flapsNBT = new ListNBT();
        if (!this.flapsToSend.isEmpty()) {
            for (Pair pair : this.flapsToSend) {
                CompoundNBT flap = new CompoundNBT();
                flap.func_74768_a("Flap", ((Direction)pair.getKey()).func_176745_a());
                flap.func_74757_a("FlapInward", ((Boolean)pair.getValue()).booleanValue());
                flapsNBT.add((Object)flap);
            }
            compound.func_218657_a("TriggerFlaps", (INBT)flapsNBT);
            this.flapsToSend.clear();
        }
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        HashSet<Direction> newFlaps = new HashSet<Direction>(6);
        ListNBT flapsNBT = compound.func_150295_c("Flaps", 3);
        for (INBT inbt : flapsNBT) {
            if (!(inbt instanceof IntNBT)) continue;
            newFlaps.add(Direction.func_82600_a((int)((IntNBT)inbt).func_150287_d()));
        }
        this.sides.clear();
        ListNBT sidesNBT = compound.func_150295_c("Sides", 3);
        for (INBT inbt : sidesNBT) {
            if (!(inbt instanceof IntNBT)) continue;
            this.sides.add(Direction.func_82600_a((int)((IntNBT)inbt).func_150287_d()));
        }
        for (Direction d : Iterate.directions) {
            if (!newFlaps.contains(d)) {
                this.flaps.remove(d);
                continue;
            }
            if (this.flaps.containsKey(d)) continue;
            this.flaps.put(d, new InterpolatedChasingValue().start(0.25f).target(0.0f).withSpeed(0.05f));
        }
        if (!compound.func_74764_b("Sides") && compound.func_74764_b("Flaps")) {
            this.sides.addAll(this.flaps.keySet());
        }
        super.fromTag(state, compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (!compound.func_74764_b("TriggerFlaps")) {
            return;
        }
        flapsNBT = compound.func_150295_c("TriggerFlaps", 10);
        for (INBT inbt : flapsNBT) {
            CompoundNBT flap = (CompoundNBT)inbt;
            Direction side = Direction.func_82600_a((int)flap.func_74762_e("Flap"));
            this.flap(side, flap.func_74767_n("FlapInward"));
        }
    }

    public void updateTunnelConnections() {
        this.flaps.clear();
        this.sides.clear();
        BlockState tunnelState = this.func_195044_w();
        for (Direction direction : Iterate.horizontalDirections) {
            if (direction.func_176740_k() != tunnelState.func_177229_b((Property)BlockStateProperties.field_208199_z)) {
                boolean positive = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ^ direction.func_176740_k() == Direction.Axis.Z;
                BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)tunnelState.func_177229_b(BeltTunnelBlock.SHAPE));
                if (BeltTunnelBlock.isStraight(tunnelState) || positive && shape == BeltTunnelBlock.Shape.T_LEFT || !positive && shape == BeltTunnelBlock.Shape.T_RIGHT) continue;
            }
            this.sides.add(direction);
            BlockState nextState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction));
            if (nextState.func_177230_c() instanceof BeltTunnelBlock || nextState.func_177230_c() instanceof BeltFunnelBlock && nextState.func_177229_b(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && nextState.func_177229_b((Property)BeltFunnelBlock.field_185512_D) == direction.func_176734_d()) continue;
            this.flaps.put(direction, new InterpolatedChasingValue().start(0.25f).target(0.0f).withSpeed(0.05f));
        }
        this.sendData();
    }

    public void flap(Direction side, boolean inward) {
        if (this.field_145850_b.field_72995_K) {
            if (this.flaps.containsKey(side)) {
                this.flaps.get(side).set(inward ? -1.0f : 1.0f);
            }
            return;
        }
        this.flapsToSend.add((Pair<Direction, Boolean>)Pair.of((Object)side, (Object)inward));
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.flapsToSend.isEmpty()) {
                this.sendData();
            }
            return;
        }
        this.flaps.forEach((d, value) -> value.tick());
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        Object capBelow;
        TileEntity teBelow;
        if (capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(capability, side);
        }
        if (!this.cap.isPresent() && AllBlocks.BELT.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())) && (teBelow = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && (capBelow = teBelow.getCapability(capability, Direction.UP).orElse(null)) != null) {
            this.cap = LazyOptional.of(() -> capBelow).cast();
        }
        return this.cap.cast();
    }
}

