/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelShapes;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BeltTunnelBlock
extends Block
implements ITE<BeltTunnelTileEntity>,
IWrenchable {
    public static final Property<Shape> SHAPE = EnumProperty.func_177709_a((String)"shape", Shape.class);
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.field_208199_z;

    public BeltTunnelBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)Shape.STRAIGHT)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BeltTunnelShapes.getShape(state);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.ANDESITE_TUNNEL.create();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
        if (!this.isValidPositionForPlacement(state, worldIn, pos)) {
            return false;
        }
        return (Boolean)blockState.func_177229_b((Property)BeltBlock.CASING) != false;
    }

    public boolean isValidPositionForPlacement(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
        if (!AllBlocks.BELT.has(blockState)) {
            return false;
        }
        return blockState.func_177229_b(BeltBlock.SLOPE) == BeltSlope.HORIZONTAL;
    }

    public static boolean hasWindow(BlockState state) {
        return state.func_177229_b(SHAPE) == Shape.WINDOW || state.func_177229_b(SHAPE) == Shape.CLOSED;
    }

    public static boolean isStraight(BlockState state) {
        return BeltTunnelBlock.hasWindow(state) || state.func_177229_b(SHAPE) == Shape.STRAIGHT;
    }

    public static boolean isJunction(BlockState state) {
        Shape shape = (Shape)((Object)state.func_177229_b(SHAPE));
        return shape == Shape.CROSS || shape == Shape.T_LEFT || shape == Shape.T_RIGHT;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getTunnelState((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!(world instanceof WrappedWorld) && !world.func_201670_d()) {
            this.withTileEntityDo((IBlockReader)world, pos, BeltTunnelTileEntity::updateTunnelConnections);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState tunnelState;
        if (facing.func_176740_k().func_200128_b()) {
            return state;
        }
        if (!(worldIn instanceof WrappedWorld) && !worldIn.func_201670_d()) {
            this.withTileEntityDo((IBlockReader)worldIn, currentPos, BeltTunnelTileEntity::updateTunnelConnections);
        }
        if ((tunnelState = this.getTunnelState((IBlockReader)worldIn, currentPos)).func_177229_b(HORIZONTAL_AXIS) == state.func_177229_b(HORIZONTAL_AXIS) && BeltTunnelBlock.hasWindow(tunnelState) == BeltTunnelBlock.hasWindow(state)) {
            return state;
        }
        return tunnelState;
    }

    public void updateTunnel(IWorld world, BlockPos pos) {
        BlockState newTunnel;
        BlockState tunnel = world.func_180495_p(pos);
        if (tunnel != (newTunnel = this.getTunnelState((IBlockReader)world, pos))) {
            world.func_180501_a(pos, newTunnel, 3);
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof BeltTunnelTileEntity) {
                ((BeltTunnelTileEntity)te).updateTunnelConnections();
            }
        }
    }

    private BlockState getTunnelState(IBlockReader reader, BlockPos pos) {
        boolean canHaveWindow;
        BlockState state = this.func_176223_P();
        BlockState belt = reader.func_180495_p(pos.func_177977_b());
        if (AllBlocks.BELT.has(belt)) {
            state = (BlockState)state.func_206870_a(HORIZONTAL_AXIS, (Comparable)((Direction)belt.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k());
        }
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS);
        Direction left = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_176746_e();
        boolean onLeft = this.hasValidOutput(reader, pos.func_177977_b(), left);
        boolean onRight = this.hasValidOutput(reader, pos.func_177977_b(), left.func_176734_d());
        if (onLeft && onRight) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.CROSS));
        } else if (onLeft) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.T_LEFT));
        } else if (onRight) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.T_RIGHT));
        }
        if (state.func_177229_b(SHAPE) == Shape.STRAIGHT && (canHaveWindow = this.canHaveWindow(reader, pos, axis))) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW));
        }
        return state;
    }

    protected boolean canHaveWindow(IBlockReader reader, BlockPos pos, Direction.Axis axis) {
        Direction fw = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        BlockState blockState1 = reader.func_180495_p(pos.func_177972_a(fw));
        BlockState blockState2 = reader.func_180495_p(pos.func_177972_a(fw.func_176734_d()));
        boolean funnel1 = blockState1.func_177230_c() instanceof BeltFunnelBlock && blockState1.func_177229_b(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && blockState1.func_177229_b((Property)BeltFunnelBlock.field_185512_D) == fw.func_176734_d();
        boolean funnel2 = blockState2.func_177230_c() instanceof BeltFunnelBlock && blockState2.func_177229_b(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.EXTENDED && blockState2.func_177229_b((Property)BeltFunnelBlock.field_185512_D) == fw;
        boolean valid1 = blockState1.func_177230_c() instanceof BeltTunnelBlock || funnel1;
        boolean valid2 = blockState2.func_177230_c() instanceof BeltTunnelBlock || funnel2;
        boolean canHaveWindow = valid1 && valid2 && (!funnel1 || !funnel2);
        return canHaveWindow;
    }

    private boolean hasValidOutput(IBlockReader world, BlockPos pos, Direction side) {
        BlockState blockState = world.func_180495_p(pos.func_177972_a(side));
        if (AllBlocks.BELT.has(blockState)) {
            return ((Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() == side.func_176740_k();
        }
        DirectBeltInputBehaviour behaviour = TileEntityBehaviour.get(world, pos.func_177972_a(side), DirectBeltInputBehaviour.TYPE);
        return behaviour != null && behaviour.canInsertFromSide(side);
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (!BeltTunnelBlock.hasWindow(state)) {
            return ActionResultType.PASS;
        }
        Shape shape = (Shape)((Object)state.func_177229_b(SHAPE));
        shape = shape == Shape.CLOSED ? Shape.WINDOW : Shape.CLOSED;
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            world.func_180501_a(context.func_195995_a(), (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)shape)), 2);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (fromPos.equals((Object)pos.func_177977_b()) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return;
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HORIZONTAL_AXIS, SHAPE});
        super.func_206840_a(builder);
    }

    @Override
    public Class<BeltTunnelTileEntity> getTileEntityClass() {
        return BeltTunnelTileEntity.class;
    }

    public static enum Shape implements IStringSerializable
    {
        STRAIGHT,
        WINDOW,
        CLOSED,
        T_LEFT,
        T_RIGHT,
        CROSS;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

