/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.curiosities.zapper.ZapperBeamPacket;
import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class ZapperItem
extends Item {
    public ZapperItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_208103_a(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockUsed")) {
            String usedblock = NBTUtil.func_190008_d((CompoundNBT)stack.func_77978_p().func_74775_l("BlockUsed")).func_177230_c().func_149739_a();
            ItemDescription.add(tooltip, (ITextComponent)Lang.translate("blockzapper.usingBlock", new TranslationTextComponent(usedblock).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean differentBlock = false;
        if (oldStack.func_77942_o() && newStack.func_77942_o() && oldStack.func_77978_p().func_74764_b("BlockUsed") && newStack.func_77978_p().func_74764_b("BlockUsed")) {
            differentBlock = NBTUtil.func_190008_d((CompoundNBT)oldStack.func_77978_p().func_74775_l("BlockUsed")) != NBTUtil.func_190008_d((CompoundNBT)newStack.func_77978_p().func_74775_l("BlockUsed"));
        }
        return slotChanged || !this.isZapper(newStack) || differentBlock;
    }

    public boolean isZapper(ItemStack newStack) {
        return newStack.func_77973_b() instanceof ZapperItem;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            if (context.func_195991_k().field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openHandgunGUI(context.func_195996_i(), context.func_221531_n() == Hand.OFF_HAND));
                this.applyCooldown(context.func_195999_j(), context.func_195996_i(), false);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack item = player.func_184586_b(hand);
        CompoundNBT nbt = item.func_196082_o();
        if (player.func_225608_bj_()) {
            if (world.field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.openHandgunGUI(item, hand == Hand.OFF_HAND));
                this.applyCooldown(player, item, false);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)item);
        }
        boolean mainHand = hand == Hand.MAIN_HAND;
        boolean isSwap = item.func_77978_p().func_74764_b("_Swap");
        boolean gunInOtherHand = this.isZapper(player.func_184586_b(mainHand ? Hand.OFF_HAND : Hand.MAIN_HAND));
        if (mainHand && isSwap && gunInOtherHand) {
            return new ActionResult(ActionResultType.FAIL, (Object)item);
        }
        if (mainHand && !isSwap && gunInOtherHand) {
            item.func_77978_p().func_74757_a("_Swap", true);
        }
        if (!mainHand && isSwap) {
            item.func_77978_p().func_82580_o("_Swap");
        }
        if (!mainHand && gunInOtherHand) {
            player.func_184586_b(Hand.MAIN_HAND).func_77978_p().func_82580_o("_Swap");
        }
        player.func_184598_c(hand);
        ITextComponent msg = this.validateUsage(item);
        if (msg != null) {
            world.func_184133_a(player, player.func_233580_cy_(), AllSoundEvents.BLOCKZAPPER_DENY.get(), SoundCategory.BLOCKS, 1.0f, 0.5f);
            player.func_146105_b((ITextComponent)msg.func_230531_f_().func_240699_a_(TextFormatting.RED), true);
            return new ActionResult(ActionResultType.FAIL, (Object)item);
        }
        BlockState stateToUse = Blocks.field_150350_a.func_176223_P();
        if (nbt.func_74764_b("BlockUsed")) {
            stateToUse = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("BlockUsed"));
        }
        stateToUse = BlockHelper.setZeroAge(stateToUse);
        CompoundNBT data = null;
        if (AllTags.AllBlockTags.SAFE_NBT.matches(stateToUse) && nbt.func_150297_b("BlockData", 10)) {
            data = nbt.func_74775_l("BlockData");
        }
        Vector3d start = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vector3d range = player.func_70040_Z().func_186678_a((double)this.getZappingRange(item));
        BlockRayTraceResult raytrace = world.func_217299_a(new RayTraceContext(start, start.func_178787_e(range), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        BlockPos pos = raytrace.func_216350_a();
        BlockState stateReplaced = world.func_180495_p(pos);
        if (pos == null || stateReplaced.func_177230_c() == Blocks.field_150350_a) {
            this.applyCooldown(player, item, gunInOtherHand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)item);
        }
        float yaw = (float)((double)(player.field_70177_z / -180.0f) * Math.PI);
        float pitch = (float)((double)(player.field_70125_A / -180.0f) * Math.PI);
        Vector3d barrelPosNoTransform = new Vector3d(mainHand == (player.func_184591_cq() == HandSide.RIGHT) ? (double)-0.35f : (double)0.35f, (double)-0.1f, 1.0);
        Vector3d barrelPos = start.func_178787_e(barrelPosNoTransform.func_178789_a(pitch).func_178785_b(yaw));
        if (world.field_72995_K) {
            ZapperRenderHandler.dontAnimateItem(hand);
            return new ActionResult(ActionResultType.SUCCESS, (Object)item);
        }
        if (this.activate(world, player, item, stateToUse, raytrace, data)) {
            this.applyCooldown(player, item, gunInOtherHand);
            AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new ZapperBeamPacket(barrelPos, raytrace.func_216347_e(), hand, false));
            AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ZapperBeamPacket(barrelPos, raytrace.func_216347_e(), hand, true));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)item);
    }

    public ITextComponent validateUsage(ItemStack item) {
        CompoundNBT tag = item.func_196082_o();
        if (!this.canActivateWithoutSelectedBlock(item) && !tag.func_74764_b("BlockUsed")) {
            return Lang.createTranslationTextComponent("blockzapper.leftClickToSet", new Object[0]);
        }
        return null;
    }

    protected abstract boolean activate(World var1, PlayerEntity var2, ItemStack var3, BlockState var4, BlockRayTraceResult var5, CompoundNBT var6);

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void openHandgunGUI(ItemStack var1, boolean var2);

    protected abstract int getCooldownDelay(ItemStack var1);

    protected abstract int getZappingRange(ItemStack var1);

    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        return false;
    }

    protected void applyCooldown(PlayerEntity playerIn, ItemStack item, boolean dual) {
        int delay = this.getCooldownDelay(item);
        playerIn.func_184811_cZ().func_185145_a(item.func_77973_b(), dual ? delay * 2 / 3 : delay);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public static void setTileData(World world, BlockPos pos, BlockState state, CompoundNBT data) {
        TileEntity tile;
        if (data != null && (tile = world.func_175625_s(pos)) != null && !tile.func_183000_F()) {
            data.func_74768_a("x", pos.func_177958_n());
            data.func_74768_a("y", pos.func_177956_o());
            data.func_74768_a("z", pos.func_177952_p());
            tile.func_230337_a_(state, data);
        }
    }
}

