/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.simibubi.create.content.curiosities.tools.ExtendoGripItem;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class ExtendoGripInteractionPacket
extends SimplePacketBase {
    private Hand interactionHand;
    private int target;
    private Vector3d specificPoint;

    public ExtendoGripInteractionPacket(Entity target) {
        this(target, null);
    }

    public ExtendoGripInteractionPacket(Entity target, Hand hand) {
        this(target, hand, null);
    }

    public ExtendoGripInteractionPacket(Entity target, Hand hand, Vector3d specificPoint) {
        this.interactionHand = hand;
        this.specificPoint = specificPoint;
        this.target = target.func_145782_y();
    }

    public ExtendoGripInteractionPacket(PacketBuffer buffer) {
        this.target = buffer.readInt();
        int handId = buffer.readInt();
        Hand hand = this.interactionHand = handId == -1 ? null : Hand.values()[handId];
        if (buffer.readBoolean()) {
            this.specificPoint = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.target);
        buffer.writeInt(this.interactionHand == null ? -1 : this.interactionHand.ordinal());
        buffer.writeBoolean(this.specificPoint != null);
        if (this.specificPoint != null) {
            buffer.writeDouble(this.specificPoint.field_72450_a);
            buffer.writeDouble(this.specificPoint.field_72448_b);
            buffer.writeDouble(this.specificPoint.field_72449_c);
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            Entity entityByID = sender.func_71121_q().func_73045_a(this.target);
            if (entityByID != null && ExtendoGripItem.isHoldingExtendoGrip((PlayerEntity)sender)) {
                if (this.interactionHand == null) {
                    sender.func_71059_n(entityByID);
                } else if (this.specificPoint == null) {
                    sender.func_190775_a(entityByID, this.interactionHand);
                } else {
                    entityByID.func_184199_a((PlayerEntity)sender, this.specificPoint, this.interactionHand);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

