/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.symmetry;

import com.simibubi.create.content.curiosities.symmetry.SymmetryHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SymmetryEffectPacket
extends SimplePacketBase {
    private BlockPos mirror;
    private List<BlockPos> positions;

    public SymmetryEffectPacket(BlockPos mirror, List<BlockPos> positions) {
        this.mirror = mirror;
        this.positions = positions;
    }

    public SymmetryEffectPacket(PacketBuffer buffer) {
        this.mirror = buffer.func_179259_c();
        int amt = buffer.readInt();
        this.positions = new ArrayList<BlockPos>(amt);
        for (int i = 0; i < amt; ++i) {
            this.positions.add(buffer.func_179259_c());
        }
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.mirror);
        buffer.writeInt(this.positions.size());
        for (BlockPos blockPos : this.positions) {
            buffer.func_179255_a(blockPos);
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.func_71410_x().field_71439_g.func_213303_ch().func_72438_d(Vector3d.func_237491_b_((Vector3i)this.mirror)) > 100.0) {
                return;
            }
            for (BlockPos to : this.positions) {
                SymmetryHandler.drawEffect(this.mirror, to);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

