/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltShapes;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltMovementHandler;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BeltBlock
extends HorizontalKineticBlock
implements ITE<BeltTileEntity>,
ISpecialBlockItemRequirement {
    public static final Property<BeltSlope> SLOPE = EnumProperty.func_177709_a((String)"slope", BeltSlope.class);
    public static final Property<BeltPart> PART = EnumProperty.func_177709_a((String)"part", BeltPart.class);
    public static final BooleanProperty CASING = BooleanProperty.func_177716_a((String)"casing");

    public BeltBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(SLOPE, (Comparable)((Object)BeltSlope.HORIZONTAL))).func_206870_a(PART, (Comparable)((Object)BeltPart.START))).func_206870_a((Property)CASING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_149666_a(ItemGroup p_149666_1_, NonNullList<ItemStack> p_149666_2_) {
        p_149666_2_.add((Object)AllItems.BELT_CONNECTOR.asStack());
    }

    @Override
    public boolean hasShaftTowards(IWorldReader world, BlockPos pos, BlockState state, Direction face) {
        if (face.func_176740_k() != this.getRotationAxis(state)) {
            return false;
        }
        try {
            return ((BeltTileEntity)this.getTileEntity((IBlockReader)world, pos)).hasPulley();
        }
        catch (ITE.TileEntityException tileEntityException) {
            return false;
        }
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        if (state.func_177229_b(SLOPE) == BeltSlope.SIDEWAYS) {
            return Direction.Axis.Y;
        }
        return ((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176746_e().func_176740_k();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return AllItems.BELT_CONNECTOR.asStack();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity tileEntity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileEntity instanceof BeltTileEntity && ((BeltTileEntity)tileEntity).hasPulley()) {
            drops.addAll(AllBlocks.SHAFT.getDefaultState().func_215693_a(builder));
        }
        return drops;
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack p_220062_4_) {
        BeltTileEntity controllerTE = BeltHelper.getControllerTE((IWorld)worldIn, pos);
        if (controllerTE != null) {
            controllerTE.getInventory().ejectAll();
        }
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return false;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        BlockPos entityPosition = entityIn.func_233580_cy_();
        BlockPos beltPos = null;
        if (AllBlocks.BELT.has(worldIn.func_180495_p(entityPosition))) {
            beltPos = entityPosition;
        } else if (AllBlocks.BELT.has(worldIn.func_180495_p(entityPosition.func_177977_b()))) {
            beltPos = entityPosition.func_177977_b();
        }
        if (beltPos == null) {
            return;
        }
        if (!(worldIn instanceof World)) {
            return;
        }
        this.func_196262_a(worldIn.func_180495_p(beltPos), (World)worldIn, beltPos, entityIn);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        BeltTileEntity belt;
        if (!BeltBlock.canTransportObjects(state)) {
            return;
        }
        if (entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if (player.func_225608_bj_()) {
                return;
            }
            if (player.field_71075_bZ.field_75100_b) {
                return;
            }
        }
        if ((belt = BeltHelper.getSegmentTE((IWorld)worldIn, pos)) == null) {
            return;
        }
        if (entityIn instanceof ItemEntity && entityIn.func_70089_S()) {
            if (worldIn.field_72995_K) {
                return;
            }
            if (entityIn.func_213322_ci().field_72448_b > 0.0) {
                return;
            }
            if (!entityIn.func_70089_S()) {
                return;
            }
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                ItemEntity itemEntity = (ItemEntity)entityIn;
                IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                if (handler == null) {
                    return;
                }
                ItemStack remainder = handler.insertItem(0, itemEntity.func_92059_d().func_77946_l(), false);
                if (remainder.func_190926_b()) {
                    itemEntity.func_70106_y();
                }
            });
            return;
        }
        BeltTileEntity controller = BeltHelper.getControllerTE((IWorld)worldIn, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entityIn)) {
            BeltMovementHandler.TransportedEntityInfo info = controller.passengers.get(entityIn);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entityIn.func_233580_cy_())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entityIn, new BeltMovementHandler.TransportedEntityInfo(pos, state));
            entityIn.func_230245_c_(true);
        }
    }

    public static boolean canTransportObjects(BlockState state) {
        if (!AllBlocks.BELT.has(state)) {
            return false;
        }
        BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(SLOPE));
        return slope != BeltSlope.VERTICAL && slope != BeltSlope.SIDEWAYS;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_() || !player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        ItemStack heldItem = player.func_184586_b(handIn);
        boolean isShaft = AllBlocks.SHAFT.isIn(heldItem);
        boolean isHand = heldItem.func_190926_b() && handIn == Hand.MAIN_HAND;
        BeltTileEntity belt = BeltHelper.getSegmentTE((IWorld)world, pos);
        if (belt == null) {
            return ActionResultType.PASS;
        }
        if (isHand) {
            BeltTileEntity controllerBelt = belt.getControllerTE();
            if (controllerBelt == null) {
                return ActionResultType.PASS;
            }
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            controllerBelt.getInventory().applyToEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                player.field_71071_by.func_191975_a(world, transportedItemStack.stack);
                return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
            });
        }
        if (isShaft) {
            if (state.func_177229_b(PART) != BeltPart.MIDDLE) {
                return ActionResultType.PASS;
            }
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)BeltPart.PULLEY)));
            return ActionResultType.SUCCESS;
        }
        if (AllBlocks.BRASS_CASING.isIn(heldItem)) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            AllTriggers.triggerFor(AllTriggers.CASING_BELT, player);
            this.withTileEntityDo((IBlockReader)world, pos, te -> te.setCasingType(BeltTileEntity.CasingType.BRASS));
            return ActionResultType.SUCCESS;
        }
        if (AllBlocks.ANDESITE_CASING.isIn(heldItem)) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            AllTriggers.triggerFor(AllTriggers.CASING_BELT, player);
            this.withTileEntityDo((IBlockReader)world, pos, te -> te.setCasingType(BeltTileEntity.CasingType.ANDESITE));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        if (((Boolean)state.func_177229_b((Property)CASING)).booleanValue()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            this.withTileEntityDo((IBlockReader)world, pos, te -> te.setCasingType(BeltTileEntity.CasingType.NONE));
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(PART) == BeltPart.PULLEY) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            KineticTileEntity.switchToBlockState(world, pos, (BlockState)state.func_206870_a(PART, (Comparable)((Object)BeltPart.MIDDLE)));
            if (player != null && !player.func_184812_l_()) {
                player.field_71071_by.func_191975_a(world, AllBlocks.SHAFT.asStack());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SLOPE, PART, CASING});
        super.func_206840_a(builder);
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, MobEntity entity) {
        return PathNodeType.RAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        BlockHelper.addReducedDestroyEffects(state, world, pos, manager);
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BeltShapes.getShape(state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177230_c() != this) {
            return VoxelShapes.func_197880_a();
        }
        VoxelShape shape = this.func_220053_a(state, worldIn, pos, context);
        try {
            if (context.getEntity() == null) {
                return shape;
            }
            BeltTileEntity belt = (BeltTileEntity)this.getTileEntity(worldIn, pos);
            BeltTileEntity controller = belt.getControllerTE();
            if (controller == null) {
                return shape;
            }
            if (controller.passengers == null || !controller.passengers.containsKey(context.getEntity())) {
                return BeltShapes.getCollisionShape(state);
            }
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
        return shape;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.BELT.create();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)state.func_177229_b((Property)CASING) != false ? BlockRenderType.MODEL : BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static void initBelt(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (world instanceof ServerWorld && ((ServerWorld)world).func_72863_F().func_201711_g() instanceof DebugChunkGenerator) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (!AllBlocks.BELT.has(state)) {
            return;
        }
        int limit = 1000;
        BlockPos currentPos = pos;
        while (limit-- > 0) {
            BlockState currentState = world.func_180495_p(currentPos);
            if (!AllBlocks.BELT.has(currentState)) {
                world.func_175655_b(pos, true);
                return;
            }
            BlockPos nextSegmentPosition = BeltBlock.nextSegmentPosition(currentState, currentPos, false);
            if (nextSegmentPosition == null) break;
            if (!world.isAreaLoaded(nextSegmentPosition, 0)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        int index = 0;
        List<BlockPos> beltChain = BeltBlock.getBeltChain(world, currentPos);
        if (beltChain.size() < 2) {
            world.func_175655_b(currentPos, true);
            return;
        }
        for (BlockPos beltPos : beltChain) {
            TileEntity tileEntity = world.func_175625_s(beltPos);
            BlockState currentState = world.func_180495_p(beltPos);
            if (tileEntity instanceof BeltTileEntity && AllBlocks.BELT.has(currentState)) {
                BeltTileEntity te = (BeltTileEntity)tileEntity;
                te.setController(currentPos);
                te.beltLength = beltChain.size();
                te.index = index;
                te.attachKinetics();
                te.func_70296_d();
                te.sendData();
                if (te.isController() && !BeltBlock.canTransportObjects(currentState)) {
                    te.getInventory().ejectAll();
                }
            } else {
                world.func_175655_b(currentPos, true);
                return;
            }
            ++index;
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (world.field_72995_K) {
            return;
        }
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        if (isMoving) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BeltTileEntity) {
            BeltTileEntity beltTileEntity = (BeltTileEntity)te;
            if (beltTileEntity.isController()) {
                beltTileEntity.getInventory().ejectAll();
            }
            world.func_175713_t(pos);
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockState currentState;
            BlockPos currentPos = BeltBlock.nextSegmentPosition(state, pos, forward);
            if (currentPos == null || !AllBlocks.BELT.has(currentState = world.func_180495_p(currentPos))) continue;
            boolean hasPulley = false;
            TileEntity tileEntity = world.func_175625_s(currentPos);
            if (tileEntity instanceof BeltTileEntity) {
                BeltTileEntity belt = (BeltTileEntity)tileEntity;
                if (belt.isController()) {
                    belt.getInventory().ejectAll();
                }
                belt.func_145843_s();
                hasPulley = belt.hasPulley();
            }
            BlockState shaftState = (BlockState)AllBlocks.SHAFT.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)this.getRotationAxis(currentState));
            world.func_180501_a(currentPos, hasPulley ? shaftState : Blocks.field_150350_a.func_176223_P(), 3);
            world.func_217379_c(2001, currentPos, Block.func_196246_j((BlockState)currentState));
        }
    }

    public BlockState func_196271_a(BlockState state, Direction side, BlockState p_196271_3_, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (side.func_176740_k().func_176722_c()) {
            this.updateTunnelConnections(world, pos.func_177984_a());
        }
        return state;
    }

    private void updateTunnelConnections(IWorld world, BlockPos pos) {
        Block tunnelBlock = world.func_180495_p(pos).func_177230_c();
        if (tunnelBlock instanceof BeltTunnelBlock) {
            ((BeltTunnelBlock)tunnelBlock).updateTunnel(world, pos);
        }
    }

    public static List<BlockPos> getBeltChain(World world, BlockPos controllerPos) {
        BlockState state;
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        BlockState blockState = world.func_180495_p(controllerPos);
        if (!AllBlocks.BELT.has(blockState)) {
            return positions;
        }
        int limit = 1000;
        BlockPos current = controllerPos;
        while (limit-- > 0 && current != null && AllBlocks.BELT.has(state = world.func_180495_p(current))) {
            positions.add(current);
            current = BeltBlock.nextSegmentPosition(state, current, true);
        }
        return positions;
    }

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        Direction direction = (Direction)state.func_177229_b(HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)state.func_177229_b(SLOPE));
        BeltPart part = (BeltPart)((Object)state.func_177229_b(PART));
        int n = offset = forward ? 1 : -1;
        if (part == BeltPart.END && forward || part == BeltPart.START && !forward) {
            return null;
        }
        if (slope == BeltSlope.VERTICAL) {
            return pos.func_177981_b(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? offset : -offset);
        }
        pos = pos.func_177967_a(direction, offset);
        if (slope != BeltSlope.HORIZONTAL && slope != BeltSlope.SIDEWAYS) {
            return pos.func_177981_b(slope == BeltSlope.UPWARD ? offset : -offset);
        }
        return pos;
    }

    public static boolean canAccessFromSide(Direction facing, BlockState belt) {
        return true;
    }

    @Override
    public Class<BeltTileEntity> getTileEntityClass() {
        return BeltTileEntity.class;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state) {
        ArrayList<ItemStack> required = new ArrayList<ItemStack>();
        if (state.func_177229_b(PART) != BeltPart.MIDDLE) {
            required.add(AllBlocks.SHAFT.asStack());
        }
        if (state.func_177229_b(PART) == BeltPart.START) {
            required.add(AllItems.BELT_CONNECTOR.asStack());
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        BlockState rotate = super.func_185499_a(state, rot);
        if (state.func_177229_b(SLOPE) != BeltSlope.VERTICAL) {
            return rotate;
        }
        if (((Direction)state.func_177229_b(HORIZONTAL_FACING)).func_176743_c() != ((Direction)rotate.func_177229_b(HORIZONTAL_FACING)).func_176743_c()) {
            if (state.func_177229_b(PART) == BeltPart.START) {
                return (BlockState)rotate.func_206870_a(PART, (Comparable)((Object)BeltPart.END));
            }
            if (state.func_177229_b(PART) == BeltPart.END) {
                return (BlockState)rotate.func_206870_a(PART, (Comparable)((Object)BeltPart.START));
            }
        }
        return rotate;
    }
}

