/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.simple.DeferralBehaviour;
import com.simibubi.create.foundation.utility.recipe.RecipeFinder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IWorld;

public abstract class BasinOperatingTileEntity
extends KineticTileEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected IRecipe<?> currentRecipe;

    public BasinOperatingTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour(this, this::updateBasin);
        behaviours.add(this.basinChecker);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.basinRemoved = true;
        }
        this.basinRemoved = false;
        this.basinChecker.scheduleUpdate();
    }

    @Override
    public void func_73660_a() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onBasinRemoved();
            this.sendData();
            return;
        }
        super.func_73660_a();
    }

    protected boolean updateBasin() {
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return false;
        }
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return true;
        }
        List<IRecipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected <C extends IInventory> boolean matchBasinRecipe(IRecipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.isPresent()) {
            return false;
        }
        return BasinRecipe.match(basin.get(), recipe);
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional<BasinTileEntity> optionalBasin = this.getBasin();
        if (!optionalBasin.isPresent()) {
            return;
        }
        BasinTileEntity basin = optionalBasin.get();
        if (!BasinRecipe.apply(basin, this.currentRecipe)) {
            return;
        }
        Optional<ITriggerable> processedRecipeTrigger = this.getProcessedRecipeTrigger();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && processedRecipeTrigger.isPresent()) {
            AllTriggers.triggerForNearbyPlayers(processedRecipeTrigger.get(), (IWorld)this.field_145850_b, this.field_174879_c, 4);
        }
        basin.inputTank.sendDataImmediately();
        if (this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected List<IRecipe<?>> getMatchingRecipes() {
        List<IRecipe<?>> list = RecipeFinder.get(this.getRecipeCacheKey(), this.field_145850_b, this::matchStaticFilters);
        return list.stream().filter(this::matchBasinRecipe).sorted((r1, r2) -> r2.func_192400_c().size() - r1.func_192400_c().size()).collect(Collectors.toList());
    }

    protected abstract void onBasinRemoved();

    protected Optional<BasinTileEntity> getBasin() {
        if (this.field_145850_b == null) {
            return Optional.empty();
        }
        TileEntity basinTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2));
        if (!(basinTE instanceof BasinTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((BasinTileEntity)basinTE);
    }

    protected Optional<ITriggerable> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract <C extends IInventory> boolean matchStaticFilters(IRecipe<C> var1);

    protected abstract Object getRecipeCacheKey();
}

