/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BasinBlock
extends Block
implements ITE<BasinTileEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208156_I;

    public BasinBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a(p_206840_1_.func_206894_a(new Property[]{FACING}));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177984_a());
        return !(tileEntity instanceof BasinOperatingTileEntity);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.BASIN.create();
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            this.withTileEntityDo((IBlockReader)context.func_195991_k(), context.func_195995_a(), bte -> bte.onWrenched(context.func_196000_l()));
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(handIn);
        try {
            BasinTileEntity te = (BasinTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            if (!heldItem.func_190926_b()) {
                if (FluidHelper.tryEmptyItemIntoTE(worldIn, player, handIn, heldItem, te)) {
                    return ActionResultType.SUCCESS;
                }
                if (FluidHelper.tryFillItemFromTE(worldIn, player, handIn, heldItem, te)) {
                    return ActionResultType.SUCCESS;
                }
                if (EmptyingByBasin.canItemBeEmptied(worldIn, heldItem) || GenericItemFilling.canItemBeFilled(worldIn, heldItem)) {
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }
            IItemHandlerModifiable inv = (IItemHandlerModifiable)te.itemCapability.orElse((Object)new ItemStackHandler(1));
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                player.field_71071_by.func_191975_a(worldIn, inv.getStackInSlot(slot));
                inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            te.onEmptied();
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (!AllBlocks.BASIN.has(worldIn.func_180495_p(entityIn.func_233580_cy_()))) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        this.withTileEntityDo(worldIn, entityIn.func_233580_cy_(), te -> {
            ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)te.inputInventory, (ItemStack)itemEntity.func_92059_d().func_77946_l(), (boolean)false);
            if (insertItem.func_190926_b()) {
                itemEntity.func_70106_y();
                if (!itemEntity.field_70170_p.field_72995_K) {
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.BASIN_THROW, (IWorld)itemEntity.field_70170_p, itemEntity.func_233580_cy_(), 3);
                }
                return;
            }
            itemEntity.func_92058_a(insertItem);
        });
    }

    public VoxelShape func_199600_g(BlockState p_199600_1_, IBlockReader p_199600_2_, BlockPos p_199600_3_) {
        return AllShapes.BASIN_RAYTRACE_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.BASIN_BLOCK_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        if (ctx.getEntity() instanceof ItemEntity) {
            return AllShapes.BASIN_COLLISION_SHAPE;
        }
        return this.func_220053_a(state, reader, pos, ctx);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        TileEntityBehaviour.destroy((IBlockReader)worldIn, pos, FilteringBehaviour.TYPE);
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.inputInventory);
            ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.outputInventory);
            te.spoutputBuffer.forEach(is -> Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)is));
        });
        worldIn.func_175713_t(pos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        try {
            return ItemHelper.calcRedstoneFromInventory((IItemHandler)((BasinTileEntity)this.getTileEntity((IBlockReader)worldIn, (BlockPos)pos)).inputInventory);
        }
        catch (ITE.TileEntityException tileEntityException) {
            return 0;
        }
    }

    @Override
    public Class<BasinTileEntity> getTileEntityClass() {
        return BasinTileEntity.class;
    }

    public static boolean canOutputTo(IBlockReader world, BlockPos basinPos, Direction direction) {
        BlockPos neighbour = basinPos.func_177972_a(direction);
        if (!world.func_180495_p(neighbour).func_196952_d(world, neighbour).func_197766_b()) {
            return false;
        }
        BlockPos offset = basinPos.func_177977_b().func_177972_a(direction);
        DirectBeltInputBehaviour directBeltInputBehaviour = TileEntityBehaviour.get(world, offset, DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour != null) {
            return directBeltInputBehaviour.canInsertFromSide(direction);
        }
        return false;
    }
}

