/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankConnectivityHandler;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.processing.EmptyingByBasin;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTankBlock
extends Block
implements IWrenchable,
ITE<FluidTankTileEntity> {
    public static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.func_177716_a((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.func_177709_a((String)"shape", Shape.class);
    private boolean creative;
    public static final SoundType SILENCED_METAL = new SoundType(0.1f, 1.5f, SoundEvents.field_187766_dk, SoundEvents.field_187778_dq, SoundEvents.field_187772_dn, SoundEvents.field_187770_dm, SoundEvents.field_187768_dl);

    public static FluidTankBlock regular(AbstractBlock.Properties p_i48440_1_) {
        return new FluidTankBlock(p_i48440_1_, false);
    }

    public static FluidTankBlock creative(AbstractBlock.Properties p_i48440_1_) {
        return new FluidTankBlock(p_i48440_1_, true);
    }

    protected FluidTankBlock(AbstractBlock.Properties p_i48440_1_, boolean creative) {
        super(p_i48440_1_);
        this.creative = creative;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW)));
    }

    public static boolean isTank(BlockState state) {
        return state.func_177230_c() instanceof FluidTankBlock;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.func_177230_c() == state.func_177230_c()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withTileEntityDo((IBlockReader)world, pos, FluidTankTileEntity::updateConnectivity);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        FluidTankTileEntity tankAt = FluidTankConnectivityHandler.anyTankAt(world, pos);
        if (tankAt == null) {
            return 0;
        }
        FluidTankTileEntity controllerTE = tankAt.getControllerTE();
        if (controllerTE == null || !controllerTE.window) {
            return 0;
        }
        return tankAt.luminosity;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        this.withTileEntityDo((IBlockReader)context.func_195991_k(), context.func_195995_a(), FluidTankTileEntity::toggleWindows);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        FluidTankTileEntity controllerTE;
        Fluid fluid;
        ItemStack heldItem = player.func_184586_b(hand);
        boolean onClient = world.field_72995_K;
        if (heldItem.func_190926_b()) {
            return ActionResultType.PASS;
        }
        if (!player.func_184812_l_()) {
            return ActionResultType.PASS;
        }
        FluidHelper.FluidExchange exchange = null;
        FluidTankTileEntity te = FluidTankConnectivityHandler.anyTankAt((IBlockReader)world, pos);
        if (te == null) {
            return ActionResultType.FAIL;
        }
        LazyOptional tankCapability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        if (!tankCapability.isPresent()) {
            return ActionResultType.PASS;
        }
        IFluidHandler fluidTank = (IFluidHandler)tankCapability.orElse(null);
        FluidStack prevFluidInTank = fluidTank.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoTE(world, player, hand, heldItem, te)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromTE(world, player, hand, heldItem, te)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (EmptyingByBasin.canItemBeEmptied(world, heldItem) || GenericItemFilling.canItemBeFilled(world, heldItem)) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInTank = tankCapability.map(fh -> fh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            FluidStack fluidInItem;
            if (this.creative && !onClient && !(fluidInItem = EmptyingByBasin.emptyItem(world, heldItem, true).getFirst()).isEmpty() && fluidTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)fluidTank).setContainedFluid(fluidInItem);
            }
            fluid = fluidInTank.getFluid();
            fluidState = fluid.func_207188_f().func_206883_i();
            FluidAttributes attributes = fluid.getAttributes();
            soundevent = attributes.getEmptySound();
            if (soundevent == null) {
                SoundEvent soundEvent = soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            }
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            if (this.creative && !onClient && fluidTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)fluidTank).setContainedFluid(FluidStack.EMPTY);
            }
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.func_207188_f().func_206883_i();
            soundevent = fluid.getAttributes().getFillSound();
            if (soundevent == null) {
                SoundEvent soundEvent = soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
            }
        }
        if (soundevent != null && !onClient) {
            float pitch = MathHelper.func_76131_a((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FluidTankTileEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 0.5f, pitch += (world.field_73012_v.nextFloat() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidStackIdentical(prevFluidInTank) && te instanceof FluidTankTileEntity && (controllerTE = te.getControllerTE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleData blockParticleData = new BlockParticleData(ParticleTypes.field_197611_d, fluidState);
                float level = (float)fluidInTank.getAmount() / (float)fluidTank.getTankCapacity(0);
                boolean reversed = fluidInTank.getFluid().getAttributes().isLighterThanAir();
                if (reversed) {
                    level = 1.0f - level;
                }
                Vector3d vec = ray.func_216347_e();
                vec = new Vector3d(vec.field_72450_a, (double)((float)controllerTE.func_174877_v().func_177956_o() + level * ((float)controllerTE.height - 0.5f) + 0.25f), vec.field_72449_c);
                Vector3d motion = player.func_213303_ch().func_178788_d(vec).func_186678_a((double)0.05f);
                vec = vec.func_178787_e(motion);
                world.func_195594_a((IParticleData)blockParticleData, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                return ActionResultType.SUCCESS;
            }
            controllerTE.sendDataImmediately();
            controllerTE.func_70296_d();
        }
        return ActionResultType.SUCCESS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && (state.func_177230_c() != newState.func_177230_c() || !newState.hasTileEntity())) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidTankTileEntity)) {
                return;
            }
            FluidTankTileEntity tankTE = (FluidTankTileEntity)te;
            world.func_175713_t(pos);
            FluidTankConnectivityHandler.splitTank(tankTE);
        }
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.creative ? AllTileEntities.CREATIVE_FLUID_TANK.create() : AllTileEntities.FLUID_TANK.create();
    }

    @Override
    public Class<FluidTankTileEntity> getTileEntityClass() {
        return FluidTankTileEntity.class;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        switch ((Shape)((Object)state.func_177229_b(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            }
            case WINDOW_NW: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            }
            case WINDOW_SE: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            }
            case WINDOW_SW: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            }
        }
        return state;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        switch ((Shape)((Object)state.func_177229_b(SHAPE))) {
            case WINDOW_NE: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            }
            case WINDOW_NW: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            }
            case WINDOW_SE: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            }
            case WINDOW_SW: {
                return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            }
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().func_74764_b("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public static enum Shape implements IStringSerializable
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

