/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedTileEntityBehaviour;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;

public class FluidPipeTileEntity
extends SmartTileEntity {
    public FluidPipeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new StandardPipeFluidTransportBehaviour(this));
        behaviours.add(new BracketedTileEntityBehaviour(this, this::canHaveBracket).withTrigger(state -> AllTriggers.BRACKET_PIPE));
    }

    private boolean canHaveBracket(BlockState state) {
        return !(state.func_177230_c() instanceof EncasedPipeBlock);
    }

    class StandardPipeFluidTransportBehaviour
    extends FluidTransportBehaviour {
        public StandardPipeFluidTransportBehaviour(SmartTileEntity te) {
            super(te);
        }

        @Override
        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return (FluidPipeBlock.isPipe(state) || state.func_177230_c() instanceof EncasedPipeBlock) && (Boolean)state.func_177229_b((Property)FluidPipeBlock.field_196491_B.get(direction)) != false;
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(IBlockDisplayReader world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour pipeBehaviour;
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && AllBlocks.ENCASED_FLUID_PIPE.has(state)) {
                return FluidTransportBehaviour.AttachmentTypes.RIM;
            }
            BlockPos offsetPos = pos.func_177972_a(direction);
            if (!FluidPipeBlock.isPipe(world.func_180495_p(offsetPos)) && (pipeBehaviour = TileEntityBehaviour.get((IBlockReader)world, offsetPos, FluidTransportBehaviour.TYPE)) != null && pipeBehaviour.canHaveFlowToward(world.func_180495_p(offsetPos), direction.func_176734_d())) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM && !FluidPipeBlock.shouldDrawRim(world, pos, state, direction)) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

