/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.actors.FillingBySpout;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.BeltProcessingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModList;

public class SpoutTileEntity
extends SmartTileEntity {
    private static final boolean IS_TIC_LOADED;
    private static final Class<?> CASTING_FLUID_HANDLER_CLASS;
    public static final int FILLING_TIME = 20;
    protected BeltProcessingBehaviour beltProcessing;
    protected int processingTicks = -1;
    protected boolean sendSplash;
    private boolean shouldAnimate = true;
    SmartFluidTankBehaviour tank;
    protected static int SPLASH_PARTICLE_COUNT;

    public SpoutTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, -2.0, 0.0);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single(this, 1000);
        behaviours.add(this.tank);
        this.beltProcessing = new BeltProcessingBehaviour(this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add(this.beltProcessing);
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!FillingBySpout.canItemBeFilled(this.field_145850_b, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (FillingBySpout.getRequiredAmountForItem(this.field_145850_b, transported.stack, this.getCurrentFluidInTank()) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        this.shouldAnimate = true;
        if (this.processingTicks != -1 && this.processingTicks != 5) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!FillingBySpout.canItemBeFilled(this.field_145850_b, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = FillingBySpout.getRequiredAmountForItem(this.field_145850_b, transported.stack, fluid.copy());
        if (requiredAmountForItem == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 20;
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        ItemStack out = FillingBySpout.fillItem(this.field_145850_b, requiredAmountForItem, transported.stack, fluid);
        if (!out.func_190926_b()) {
            ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.func_190926_b()) {
                held = transported.copy();
            }
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, held));
        }
        AllTriggers.triggerForNearbyPlayers(AllTriggers.SPOUT, (IWorld)this.field_145850_b, this.field_174879_c, 5);
        if (out.func_77973_b() instanceof PotionItem && !PotionUtils.func_185189_a((ItemStack)out).isEmpty()) {
            AllTriggers.triggerForNearbyPlayers(AllTriggers.SPOUT_POTION, (IWorld)this.field_145850_b, this.field_174879_c, 5);
        }
        this.tank.getPrimaryHandler().setFluid(fluid);
        this.sendSplash = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private void processTicCastBlock() {
        if (!IS_TIC_LOADED || CASTING_FLUID_HANDLER_CLASS == null) {
            return;
        }
        if (this.field_145850_b == null) {
            return;
        }
        IFluidHandler localTank = (IFluidHandler)this.tank.getCapability().orElse(null);
        if (localTank == null) {
            return;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        if (fluid.getAmount() == 0) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(2));
        if (te == null) {
            return;
        }
        IFluidHandler handler = this.getFluidHandler(this.field_174879_c.func_177979_c(2), Direction.UP);
        if (!CASTING_FLUID_HANDLER_CLASS.isInstance(handler)) {
            return;
        }
        if (handler.getTanks() != 1) {
            return;
        }
        if (!handler.isFluidValid(0, this.getCurrentFluidInTank())) {
            return;
        }
        FluidStack containedFluid = handler.getFluidInTank(0);
        if (!containedFluid.isEmpty() && !containedFluid.isFluidEqual(fluid)) {
            return;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 20;
            this.notifyUpdate();
            return;
        }
        FluidStack drained = localTank.drain(144, IFluidHandler.FluidAction.SIMULATE);
        if (!drained.isEmpty()) {
            int filled = handler.fill(drained, IFluidHandler.FluidAction.SIMULATE);
            this.sendSplash = this.shouldAnimate = filled > 0;
            if (this.processingTicks == 5) {
                if (filled > 0 && !(drained = localTank.drain(filled, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                    FluidStack fillStack = drained.copy();
                    fillStack.setAmount(Math.min(drained.getAmount(), 6));
                    drained.shrink(filled);
                    fillStack.setAmount(filled);
                    handler.fill(fillStack, IFluidHandler.FluidAction.EXECUTE);
                }
                this.tank.getPrimaryHandler().setFluid(fluid);
                this.notifyUpdate();
            }
        }
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("ProcessingTicks", this.processingTicks);
        if (this.sendSplash && clientPacket) {
            compound.func_74757_a("Splash", true);
            this.sendSplash = false;
        }
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.processingTicks = compound.func_74762_e("ProcessingTicks");
        if (!clientPacket) {
            return;
        }
        if (compound.func_74764_b("Splash")) {
            this.spawnSplash(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && side != Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.processTicCastBlock();
        if (this.processingTicks >= 0) {
            --this.processingTicks;
        }
        if (this.processingTicks >= 8 && this.field_145850_b.field_72995_K && this.shouldAnimate) {
            this.spawnProcessingParticles(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    protected void spawnProcessingParticles(FluidStack fluid) {
        Vector3d vec = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        vec = vec.func_178786_a(0.0, 0.5, 0.0);
        IParticleData particle = FluidFX.getFluidParticle(fluid);
        this.field_145850_b.func_195589_b(particle, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, (double)-0.1f, 0.0);
    }

    protected void spawnSplash(FluidStack fluid) {
        Vector3d vec = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        vec = vec.func_178786_a(0.0, 1.6875, 0.0);
        IParticleData particle = FluidFX.getFluidParticle(fluid);
        for (int i = 0; i < SPLASH_PARTICLE_COUNT; ++i) {
            Vector3d m = VecHelper.offsetRandomly(Vector3d.field_186680_a, this.field_145850_b.field_73012_v, 0.125f);
            m = new Vector3d(m.field_72450_a, Math.abs(m.field_72448_b), m.field_72449_c);
            this.field_145850_b.func_195589_b(particle, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
        }
    }

    @Nullable
    private IFluidHandler getFluidHandler(BlockPos pos, Direction direction) {
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        return te != null ? (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).orElse(null) : null;
    }

    public int getCorrectedProcessingTicks() {
        if (this.shouldAnimate) {
            return this.processingTicks;
        }
        return -1;
    }

    static {
        Class<?> testClass;
        IS_TIC_LOADED = ModList.get().isLoaded("tconstruct");
        try {
            testClass = Class.forName("slimeknights.tconstruct.library.smeltery.CastingFluidHandler");
        }
        catch (ClassNotFoundException e) {
            testClass = null;
        }
        CASTING_FLUID_HANDLER_CLASS = testClass;
        SPLASH_PARTICLE_COUNT = 20;
    }
}

