/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train.capability;

import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class MinecartControllerUpdatePacket
extends SimplePacketBase {
    int entityID;
    CompoundNBT nbt;

    public MinecartControllerUpdatePacket(MinecartController controller) {
        this.entityID = controller.cart().func_145782_y();
        this.nbt = controller.serializeNBT();
    }

    public MinecartControllerUpdatePacket(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.nbt = buffer.func_150793_b();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        buffer.func_150786_a(this.nbt);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::handleCL));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleCL() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entityByID = world.func_73045_a(this.entityID);
        if (entityByID == null) {
            return;
        }
        entityByID.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY).ifPresent(mc -> mc.deserializeNBT(this.nbt));
    }
}

