/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train.capability;

import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.WorldAttached;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class CapabilityMinecartController
implements ICapabilitySerializable<CompoundNBT> {
    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID = new WorldAttached<Map>(HashMap::new);
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling = new WorldAttached<Set>(HashSet::new);
    static WorldAttached<List<AbstractMinecartEntity>> queuedAdditions = new WorldAttached<List>(() -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    static WorldAttached<List<UUID>> queuedUnloads = new WorldAttached<List>(() -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    @CapabilityInject(value=MinecartController.class)
    public static Capability<MinecartController> MINECART_CONTROLLER_CAPABILITY = null;
    private final LazyOptional<MinecartController> cap;
    private MinecartController handler;

    public static void tick(World world) {
        ArrayList toRemove = new ArrayList();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((IWorld)world);
        List<AbstractMinecartEntity> queued = queuedAdditions.get((IWorld)world);
        List<UUID> queuedRemovals = queuedUnloads.get((IWorld)world);
        Set<UUID> cartsWithCoupling = loadedMinecartsWithCoupling.get((IWorld)world);
        Set<UUID> keySet = carts.keySet();
        keySet.removeAll(queuedRemovals);
        cartsWithCoupling.removeAll(queuedRemovals);
        for (AbstractMinecartEntity abstractMinecartEntity : queued) {
            AbstractMinecartEntity minecartEntity;
            MinecartController minecartController;
            UUID uniqueID = abstractMinecartEntity.func_110124_au();
            if (world.field_72995_K && carts.containsKey(uniqueID) && (minecartController = carts.get(uniqueID)) != null && (minecartEntity = minecartController.cart()) != null && minecartEntity.func_145782_y() != abstractMinecartEntity.func_145782_y()) continue;
            cartsWithCoupling.remove(uniqueID);
            LazyOptional capability = abstractMinecartEntity.getCapability(MINECART_CONTROLLER_CAPABILITY);
            MinecartController controller = (MinecartController)capability.orElse(null);
            capability.addListener((NonNullConsumer)new MinecartRemovalListener(world, abstractMinecartEntity));
            carts.put(uniqueID, controller);
            capability.ifPresent(mc -> {
                if (mc.isLeadingCoupling()) {
                    cartsWithCoupling.add(uniqueID);
                }
            });
            if (world.field_72995_K || controller == null) continue;
            controller.sendData();
        }
        queuedRemovals.clear();
        queued.clear();
        for (Map.Entry entry : carts.entrySet()) {
            MinecartController controller = (MinecartController)entry.getValue();
            if (controller != null && controller.isPresent()) {
                controller.tick();
                continue;
            }
            toRemove.add(entry.getKey());
        }
        cartsWithCoupling.removeAll(toRemove);
        keySet.removeAll(toRemove);
    }

    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        ChunkPos chunkPos = event.getChunk().func_76632_l();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get(event.getWorld());
        for (MinecartController minecartController : carts.values()) {
            if (minecartController == null || !minecartController.isPresent()) continue;
            AbstractMinecartEntity cart = minecartController.cart();
            if (cart.field_70176_ah != chunkPos.field_77276_a || cart.field_70164_aj != chunkPos.field_77275_b) continue;
            queuedUnloads.get(event.getWorld()).add(cart.func_110124_au());
        }
    }

    protected static void onCartRemoved(World world, AbstractMinecartEntity entity) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((IWorld)world);
        List<UUID> unloads = queuedUnloads.get((IWorld)world);
        UUID uniqueID = entity.func_110124_au();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        CapabilityMinecartController.handleKilledMinecart(world, carts.get(uniqueID), entity.func_213303_ch());
    }

    protected static void handleKilledMinecart(World world, MinecartController controller, Vector3d removedPos) {
        if (controller == null) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            AbstractMinecartEntity cart;
            MinecartController next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next == null || next == MinecartController.EMPTY) continue;
            next.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward) || (cart = next.cart()) == null) continue;
            Vector3d itemPos = cart.func_213303_ch().func_178787_e(removedPos).func_186678_a(0.5);
            ItemEntity itemEntity = new ItemEntity(world, itemPos.field_72450_a, itemPos.field_72448_b, itemPos.field_72449_c, AllItems.MINECART_COUPLING.asStack());
            itemEntity.func_174869_p();
            world.func_217376_c((Entity)itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(World world, UUID cartId) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((IWorld)world);
        if (carts == null) {
            return null;
        }
        if (!carts.containsKey(cartId)) {
            return null;
        }
        return carts.get(cartId);
    }

    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (!(entity instanceof AbstractMinecartEntity)) {
            return;
        }
        CapabilityMinecartController capability = new CapabilityMinecartController((AbstractMinecartEntity)entity);
        ResourceLocation id = Create.asResource("minecart_controller");
        event.addCapability(id, (ICapabilityProvider)capability);
        event.addListener(() -> {
            if (capability.cap.isPresent()) {
                capability.cap.invalidate();
            }
        });
        queuedAdditions.get((IWorld)entity.func_130014_f_()).add((AbstractMinecartEntity)entity);
    }

    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof AbstractMinecartEntity)) {
            return;
        }
        entity.getCapability(MINECART_CONTROLLER_CAPABILITY).ifPresent(MinecartController::sendData);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(MinecartController.class, (Capability.IStorage)new Capability.IStorage<MinecartController>(){

            public INBT writeNBT(Capability<MinecartController> capability, MinecartController instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<MinecartController> capability, MinecartController instance, Direction side, INBT base) {
                instance.deserializeNBT((CompoundNBT)base);
            }
        }, MinecartController::empty);
    }

    public CapabilityMinecartController(AbstractMinecartEntity minecart) {
        this.handler = new MinecartController(minecart);
        this.cap = LazyOptional.of(() -> this.handler);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MINECART_CONTROLLER_CAPABILITY) {
            return this.cap.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.handler.deserializeNBT(nbt);
    }

    public static class MinecartRemovalListener
    implements NonNullConsumer<LazyOptional<MinecartController>> {
        private World world;
        private AbstractMinecartEntity cart;

        public MinecartRemovalListener(World world, AbstractMinecartEntity cart) {
            this.world = world;
            this.cart = cart;
        }

        public boolean equals(Object obj) {
            return obj instanceof MinecartRemovalListener;
        }

        public int hashCode() {
            return 100;
        }

        public void accept(LazyOptional<MinecartController> t) {
            CapabilityMinecartController.onCartRemoved(this.world, this.cart);
        }
    }
}

