/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.MatrixStacker;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;

public class CouplingRenderer {
    public static void renderAll(MatrixStack ms, IRenderTypeBuffer buffer) {
        CouplingHandler.forEachLoadedCoupling((World)Minecraft.func_71410_x().field_71441_e, c -> {
            if (((MinecartController)c.getFirst()).hasContraptionCoupling(true)) {
                return;
            }
            CouplingRenderer.renderCoupling(ms, buffer, c.map(MinecartController::cart));
        });
    }

    public static void tickDebugModeRenders() {
        if (KineticDebugger.isActive()) {
            CouplingHandler.forEachLoadedCoupling((World)Minecraft.func_71410_x().field_71441_e, CouplingRenderer::doDebugRender);
        }
    }

    public static void renderCoupling(MatrixStack ms, IRenderTypeBuffer buffer, Couple<AbstractMinecartEntity> carts) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (carts.getFirst() == null || carts.getSecond() == null) {
            return;
        }
        Couple<Integer> lightValues = carts.map(c -> WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)new BlockPos(c.func_174813_aQ().func_189972_c())));
        Vector3d center = ((AbstractMinecartEntity)carts.getFirst()).func_213303_ch().func_178787_e(((AbstractMinecartEntity)carts.getSecond()).func_213303_ch()).func_186678_a(0.5);
        Couple<CartEndpoint> transforms = carts.map(c -> CouplingRenderer.getSuitableCartEndpoint(c, center));
        BlockState renderState = Blocks.field_150350_a.func_176223_P();
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        SuperByteBuffer attachment = AllBlockPartials.COUPLING_ATTACHMENT.renderOn(renderState);
        SuperByteBuffer ring = AllBlockPartials.COUPLING_RING.renderOn(renderState);
        SuperByteBuffer connector = AllBlockPartials.COUPLING_CONNECTOR.renderOn(renderState);
        Vector3d zero = Vector3d.field_186680_a;
        Vector3d firstEndpoint = ((CartEndpoint)transforms.getFirst()).apply(zero);
        Vector3d secondEndpoint = ((CartEndpoint)transforms.getSecond()).apply(zero);
        Vector3d endPointDiff = secondEndpoint.func_178788_d(firstEndpoint);
        double connectorYaw = -Math.atan2(endPointDiff.field_72449_c, endPointDiff.field_72450_a) * 180.0 / Math.PI;
        double connectorPitch = Math.atan2(endPointDiff.field_72448_b, endPointDiff.func_216372_d(1.0, 0.0, 1.0).func_72433_c()) * 180.0 / Math.PI;
        MatrixStacker msr = MatrixStacker.of(ms);
        carts.forEachWithContext((cart, isFirst) -> {
            CartEndpoint cartTransform = (CartEndpoint)transforms.get((boolean)isFirst);
            ms.func_227860_a_();
            cartTransform.apply(ms);
            attachment.light((Integer)lightValues.get((boolean)isFirst)).renderInto(ms, builder);
            msr.rotateY(connectorYaw - (double)cartTransform.yaw);
            ring.light((Integer)lightValues.get((boolean)isFirst)).renderInto(ms, builder);
            ms.func_227865_b_();
        });
        int l1 = (Integer)lightValues.getFirst();
        int l2 = (Integer)lightValues.getSecond();
        int meanBlockLight = ((l1 >> 4 & 0xF) + (l2 >> 4 & 0xF)) / 2;
        int meanSkyLight = ((l1 >> 20 & 0xF) + (l2 >> 20 & 0xF)) / 2;
        ms.func_227860_a_();
        msr.translate(firstEndpoint).rotateY(connectorYaw).rotateZ(connectorPitch);
        ms.func_227862_a_((float)endPointDiff.func_72433_c(), 1.0f, 1.0f);
        connector.light(meanSkyLight << 20 | meanBlockLight << 4).renderInto(ms, builder);
        ms.func_227865_b_();
    }

    private static CartEndpoint getSuitableCartEndpoint(AbstractMinecartEntity cart, Vector3d centerOfCoupling) {
        boolean isBackFaceCloser;
        long i = (long)cart.func_145782_y() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float x = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float y = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f + 0.375f;
        float z = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float pt = Minecraft.func_71410_x().func_184121_ak();
        double xIn = MathHelper.func_219803_d((double)pt, (double)cart.field_70142_S, (double)cart.func_226277_ct_());
        double yIn = MathHelper.func_219803_d((double)pt, (double)cart.field_70137_T, (double)cart.func_226278_cu_());
        double zIn = MathHelper.func_219803_d((double)pt, (double)cart.field_70136_U, (double)cart.func_226281_cx_());
        float yaw = MathHelper.func_219799_g((float)pt, (float)cart.field_70126_B, (float)cart.field_70177_z);
        float pitch = MathHelper.func_219799_g((float)pt, (float)cart.field_70127_C, (float)cart.field_70125_A);
        float roll = (float)cart.func_70496_j() - pt;
        float rollAmplifier = cart.func_70491_i() - pt;
        if (rollAmplifier < 0.0f) {
            rollAmplifier = 0.0f;
        }
        roll = roll > 0.0f ? MathHelper.func_76126_a((float)roll) * roll * rollAmplifier / 10.0f * (float)cart.func_70493_k() : 0.0f;
        Vector3d positionVec = new Vector3d(xIn, yIn, zIn);
        Vector3d frontVec = positionVec.func_178787_e(VecHelper.rotate(new Vector3d(0.5, 0.0, 0.0), 180.0f - yaw, Direction.Axis.Y));
        Vector3d backVec = positionVec.func_178787_e(VecHelper.rotate(new Vector3d(-0.5, 0.0, 0.0), 180.0f - yaw, Direction.Axis.Y));
        Vector3d railVecOfPos = cart.func_70489_a(xIn, yIn, zIn);
        boolean flip = false;
        if (railVecOfPos != null) {
            frontVec = cart.func_70495_a(xIn, yIn, zIn, (double)0.3f);
            backVec = cart.func_70495_a(xIn, yIn, zIn, (double)-0.3f);
            if (frontVec == null) {
                frontVec = railVecOfPos;
            }
            if (backVec == null) {
                backVec = railVecOfPos;
            }
            x = (float)((double)x + railVecOfPos.field_72450_a);
            y = (float)((double)y + (frontVec.field_72448_b + backVec.field_72448_b) / 2.0);
            z = (float)((double)z + railVecOfPos.field_72449_c);
            Vector3d endPointDiff = backVec.func_72441_c(-frontVec.field_72450_a, -frontVec.field_72448_b, -frontVec.field_72449_c);
            if (endPointDiff.func_72433_c() != 0.0) {
                endPointDiff = endPointDiff.func_72432_b();
                yaw = (float)(Math.atan2(endPointDiff.field_72449_c, endPointDiff.field_72450_a) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(endPointDiff.field_72448_b) * 73.0);
            }
        } else {
            x = (float)((double)x + xIn);
            y = (float)((double)y + yIn);
            z = (float)((double)z + zIn);
        }
        float offsetMagnitude = 0.8125f;
        flip = isBackFaceCloser = frontVec.func_72436_e(centerOfCoupling) > backVec.func_72436_e(centerOfCoupling);
        float offset = isBackFaceCloser ? -0.8125f : 0.8125f;
        return new CartEndpoint(x, y + 0.125f, z, 180.0f - yaw, -pitch, roll, offset, flip);
    }

    public static void doDebugRender(Couple<MinecartController> c) {
        boolean yOffset = true;
        MinecartController first = (MinecartController)c.getFirst();
        AbstractMinecartEntity mainCart = first.cart();
        Vector3d mainCenter = mainCart.func_213303_ch().func_72441_c(0.0, (double)yOffset, 0.0);
        Vector3d connectedCenter = ((MinecartController)c.getSecond()).cart().func_213303_ch().func_72441_c(0.0, (double)yOffset, 0.0);
        int color = ColorHelper.mixColors(11268329, 15631730, (float)MathHelper.func_151237_a((double)(Math.abs((double)first.getCouplingLength(true) - connectedCenter.func_72438_d(mainCenter)) * 8.0), (double)0.0, (double)1.0));
        CreateClient.outliner.showLine(mainCart.func_145782_y() + "", mainCenter, connectedCenter).colored(color).lineWidth(0.125f);
        Vector3d point = mainCart.func_213303_ch().func_72441_c(0.0, (double)yOffset, 0.0);
        CreateClient.outliner.showLine(mainCart.func_145782_y() + "_dot", point, point.func_72441_c(0.0, 0.0078125, 0.0)).colored(0xFFFFFF).lineWidth(0.25f);
    }

    static class CartEndpoint {
        float x;
        float y;
        float z;
        float yaw;
        float pitch;
        float roll;
        float offset;
        boolean flip;

        public CartEndpoint(float x, float y, float z, float yaw, float pitch, float roll, float offset, boolean flip) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.roll = roll;
            this.offset = offset;
            this.flip = flip;
        }

        public Vector3d apply(Vector3d vec) {
            vec = vec.func_72441_c((double)this.offset, 0.0, 0.0);
            vec = VecHelper.rotate(vec, this.roll, Direction.Axis.X);
            vec = VecHelper.rotate(vec, this.pitch, Direction.Axis.Z);
            vec = VecHelper.rotate(vec, this.yaw, Direction.Axis.Y);
            return vec.func_72441_c((double)this.x, (double)this.y, (double)this.z);
        }

        public void apply(MatrixStack ms) {
            ms.func_227861_a_((double)this.x, (double)this.y, (double)this.z);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(this.yaw));
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.pitch));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(this.roll));
            ms.func_227861_a_((double)this.offset, 0.0, 0.0);
            if (this.flip) {
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
        }
    }
}

