/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.pulley;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementTraits;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.LinearActuatorTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyContraption;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class PulleyTileEntity
extends LinearActuatorTileEntity {
    protected int initialOffset;

    public PulleyTileEntity(TileEntityType<? extends PulleyTileEntity> type) {
        super(type);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, (double)(-this.offset), 0.0);
    }

    public double func_145833_n() {
        return super.func_145833_n() + (double)(this.offset * this.offset);
    }

    @Override
    protected void assemble() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f) {
            return;
        }
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockPos anchor = this.field_174879_c.func_177979_c(MathHelper.func_76141_d((float)(this.offset + 1.0f)));
            this.initialOffset = MathHelper.func_76141_d((float)this.offset);
            PulleyContraption contraption = new PulleyContraption(this.initialOffset);
            boolean canAssembleStructure = contraption.assemble(this.field_145850_b, anchor);
            if (canAssembleStructure) {
                Direction movementDirection;
                Direction direction = movementDirection = this.getSpeed() > 0.0f ? Direction.DOWN : Direction.UP;
                if (ContraptionCollider.isCollidingWithWorld(this.field_145850_b, contraption, anchor.func_177972_a(movementDirection), movementDirection)) {
                    canAssembleStructure = false;
                }
            }
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            for (int i = (int)this.offset; i > 0; --i) {
                BlockPos offset = this.field_174879_c.func_177979_c(i);
                BlockState oldState = this.field_145850_b.func_180495_p(offset);
                if (oldState.func_177230_c() instanceof IWaterLoggable && oldState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)oldState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                    this.field_145850_b.func_180501_a(offset, Blocks.field_150355_j.func_176223_P(), 66);
                    continue;
                }
                this.field_145850_b.func_180501_a(offset, Blocks.field_150350_a.func_176223_P(), 66);
            }
            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(this.field_145850_b, BlockPos.field_177992_a);
                this.movedContraption = ControlledContraptionEntity.create(this.field_145850_b, this, contraption);
                this.movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
                this.field_145850_b.func_217376_c((Entity)this.movedContraption);
                this.forceMove = true;
            }
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.applyContraptionPosition();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.field_145846_f) {
                int i;
                if (this.offset > 0.0f) {
                    BlockPos magnetPos = this.field_174879_c.func_177979_c((int)this.offset);
                    FluidState ifluidstate = this.field_145850_b.func_204610_c(magnetPos);
                    this.field_145850_b.func_175655_b(magnetPos, this.field_145850_b.func_180495_p(magnetPos).func_196952_d((IBlockReader)this.field_145850_b, magnetPos).func_197766_b());
                    this.field_145850_b.func_180501_a(magnetPos, (BlockState)AllBlocks.PULLEY_MAGNET.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a)), 66);
                }
                boolean[] waterlog = new boolean[(int)this.offset];
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    BlockPos ropePos = this.field_174879_c.func_177979_c(i);
                    FluidState ifluidstate = this.field_145850_b.func_204610_c(ropePos);
                    waterlog[i] = ifluidstate.func_206886_c() == Fluids.field_204546_a;
                    this.field_145850_b.func_175655_b(ropePos, this.field_145850_b.func_180495_p(ropePos).func_196952_d((IBlockReader)this.field_145850_b, ropePos).func_197766_b());
                }
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    this.field_145850_b.func_180501_a(this.field_174879_c.func_177979_c(i), (BlockState)AllBlocks.ROPE.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(waterlog[i])), 66);
                }
            }
            if (this.movedContraption != null) {
                this.movedContraption.disassemble();
            }
        }
        if (this.movedContraption != null) {
            this.movedContraption.func_70106_y();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }

    @Override
    protected Vector3d toPosition(float offset) {
        if (this.movedContraption.getContraption() instanceof PulleyContraption) {
            PulleyContraption contraption = (PulleyContraption)this.movedContraption.getContraption();
            return Vector3d.func_237491_b_((Vector3i)contraption.anchor).func_72441_c(0.0, (double)((float)contraption.initialOffset - offset), 0.0);
        }
        return Vector3d.field_186680_a;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.movedContraption != null) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        BlockPos posBelow = this.field_174879_c.func_177979_c((int)(this.offset + this.getMovementSpeed()) + 1);
        if (!BlockMovementTraits.movementNecessary(this.field_145850_b, posBelow)) {
            return;
        }
        if (BlockMovementTraits.isBrittle(this.field_145850_b.func_180495_p(posBelow))) {
            return;
        }
        this.disassemble();
        this.assembleNextTick = true;
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.initialOffset = compound.func_74762_e("InitialOffset");
        super.fromTag(state, compound, clientPacket);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("InitialOffset", this.initialOffset);
        super.write(compound, clientPacket);
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min((Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get(), this.field_174879_c.func_177956_o() - 1));
    }

    @Override
    protected int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    protected Vector3d toMotionVector(float speed) {
        return new Vector3d(0.0, (double)(-speed), 0.0);
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP);
    }
}

