/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class MechanicalPistonBlock
extends DirectionalAxisKineticBlock
implements ITE<MechanicalPistonTileEntity> {
    public static final EnumProperty<PistonState> STATE = EnumProperty.func_177709_a((String)"state", PistonState.class);
    protected boolean isSticky;

    public static MechanicalPistonBlock normal(AbstractBlock.Properties properties) {
        return new MechanicalPistonBlock(properties, false);
    }

    public static MechanicalPistonBlock sticky(AbstractBlock.Properties properties) {
        return new MechanicalPistonBlock(properties, true);
    }

    protected MechanicalPistonBlock(AbstractBlock.Properties properties, boolean sticky) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(STATE, (Comparable)((Object)PistonState.RETRACTED)));
        this.isSticky = sticky;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE});
        super.func_206840_a(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_175142_cm()) {
            return ActionResultType.PASS;
        }
        if (player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        if (!player.func_184586_b(handIn).func_77973_b().func_206844_a((ITag)Tags.Items.SLIMEBALLS)) {
            if (player.func_184586_b(handIn).func_190926_b()) {
                this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                    te.assembleNextTick = true;
                });
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (state.func_177229_b(STATE) != PistonState.RETRACTED) {
            return ActionResultType.PASS;
        }
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        if (hit.func_216354_b() != direction) {
            return ActionResultType.PASS;
        }
        if (((MechanicalPistonBlock)state.func_177230_c()).isSticky) {
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            Vector3d vec = hit.func_216347_e();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197592_C, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0);
            return ActionResultType.SUCCESS;
        }
        worldIn.func_184133_a(null, pos, AllSoundEvents.SLIME_ADDED.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
        if (!player.func_184812_l_()) {
            player.func_184586_b(handIn).func_190918_g(1);
        }
        worldIn.func_175656_a(pos, (BlockState)((BlockState)AllBlocks.STICKY_MECHANICAL_PISTON.getDefaultState().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)AXIS_ALONG_FIRST_COORDINATE, state.func_177229_b((Property)AXIS_ALONG_FIRST_COORDINATE)));
        return ActionResultType.SUCCESS;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.MECHANICAL_PISTON.create();
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (state.func_177229_b(STATE) != PistonState.RETRACTED) {
            return ActionResultType.PASS;
        }
        return super.onWrenched(state, context);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockState block;
        BlockPos currentPos;
        int offset;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos pistonHead = null;
        BlockPos pistonBase = pos;
        boolean dropBlocks = player == null || !player.func_184812_l_();
        Integer maxPoles = MechanicalPistonBlock.maxAllowedPistonPoles();
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.func_177967_a(direction, offset);
            block = worldIn.func_180495_p(currentPos);
            if (MechanicalPistonBlock.isExtensionPole(block) && direction.func_176740_k() == ((Direction)block.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176740_k()) continue;
            if (!MechanicalPistonBlock.isPistonHead(block) || block.func_177229_b((Property)BlockStateProperties.field_208155_H) != direction) break;
            pistonHead = currentPos;
            break;
        }
        if (pistonHead != null && pistonBase != null) {
            BlockPos.func_218281_b((BlockPos)pistonBase, pistonHead).filter(p -> !p.equals((Object)pos)).forEach(p -> worldIn.func_175655_b(p, dropBlocks));
        }
        for (offset = 1; offset < maxPoles && MechanicalPistonBlock.isExtensionPole(block = worldIn.func_180495_p(currentPos = pos.func_177967_a(direction.func_176734_d(), offset))) && direction.func_176740_k() == ((Direction)block.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176740_k(); ++offset) {
            worldIn.func_175655_b(currentPos, dropBlocks);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public static int maxAllowedPistonPoles() {
        return (Integer)AllConfigs.SERVER.kinetics.maxPistonPoles.get();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(STATE) == PistonState.EXTENDED) {
            return AllShapes.MECHANICAL_PISTON_EXTENDED.get((Direction)state.func_177229_b((Property)FACING));
        }
        if (state.func_177229_b(STATE) == PistonState.MOVING) {
            return AllShapes.MECHANICAL_PISTON.get((Direction)state.func_177229_b((Property)FACING));
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public Class<MechanicalPistonTileEntity> getTileEntityClass() {
        return MechanicalPistonTileEntity.class;
    }

    public static boolean isPiston(BlockState state) {
        return AllBlocks.MECHANICAL_PISTON.has(state) || MechanicalPistonBlock.isStickyPiston(state);
    }

    public static boolean isStickyPiston(BlockState state) {
        return AllBlocks.STICKY_MECHANICAL_PISTON.has(state);
    }

    public static boolean isExtensionPole(BlockState state) {
        return AllBlocks.PISTON_EXTENSION_POLE.has(state);
    }

    public static boolean isPistonHead(BlockState state) {
        return AllBlocks.MECHANICAL_PISTON_HEAD.has(state);
    }

    public static enum PistonState implements IStringSerializable
    {
        RETRACTED,
        MOVING,
        EXTENDED;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

