/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.IControlContraption;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public abstract class LinearActuatorTileEntity
extends KineticTileEntity
implements IControlContraption {
    public float offset;
    public boolean running;
    public boolean assembleNextTick;
    public AbstractContraptionEntity movedContraption;
    protected boolean forceMove;
    protected ScrollOptionBehaviour<IControlContraption.MovementMode> movementMode;
    protected boolean waitingForSpeedChange;
    protected float clientOffsetDiff;

    public LinearActuatorTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.setLazyTickRate(3);
        this.forceMove = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour<IControlContraption.MovementMode>(IControlContraption.MovementMode.class, (ITextComponent)Lang.translate("contraptions.movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        this.movementMode.withCallback(t -> {
            this.waitingForSpeedChange = false;
        });
        behaviours.add(this.movementMode);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.movedContraption != null && !this.movedContraption.func_70089_S()) {
            this.movedContraption = null;
        }
        if (this.field_145850_b.field_72995_K) {
            this.clientOffsetDiff *= 0.75f;
        }
        if (this.waitingForSpeedChange && this.movedContraption != null) {
            if (this.field_145850_b.field_72995_K) {
                float syncSpeed = this.clientOffsetDiff / 2.0f;
                this.offset += syncSpeed;
                this.movedContraption.setContraptionMotion(this.toMotionVector(syncSpeed));
                return;
            }
            this.movedContraption.setContraptionMotion(Vector3d.field_186680_a);
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                if (this.getSpeed() == 0.0f) {
                    this.tryDisassemble();
                } else {
                    this.sendData();
                }
                return;
            }
            if (this.getSpeed() != 0.0f) {
                this.assemble();
            }
            return;
        }
        if (!this.running) {
            return;
        }
        boolean contraptionPresent = this.movedContraption != null;
        float movementSpeed = this.getMovementSpeed();
        float newOffset = this.offset + movementSpeed;
        if ((int)newOffset != (int)this.offset) {
            this.visitNewPosition();
        }
        if (!contraptionPresent || !this.movedContraption.isStalled()) {
            this.offset = newOffset;
        }
        if (contraptionPresent) {
            this.applyContraptionMotion();
        }
        int extensionRange = this.getExtensionRange();
        if (this.offset <= 0.0f || this.offset >= (float)extensionRange) {
            float f = this.offset = this.offset <= 0.0f ? 0.0f : (float)extensionRange;
            if (!this.field_145850_b.field_72995_K) {
                this.applyContraptionMotion();
                this.applyContraptionPosition();
                this.tryDisassemble();
                if (this.waitingForSpeedChange) {
                    this.forceMove = true;
                    this.sendData();
                }
            }
            return;
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.movedContraption != null && !this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    protected int getGridOffset(float offset) {
        return MathHelper.func_76125_a((int)((int)(offset + 0.5f)), (int)0, (int)this.getExtensionRange());
    }

    public float getInterpolatedOffset(float partialTicks) {
        float interpolatedOffset = MathHelper.func_76131_a((float)(this.offset + (partialTicks - 0.5f) * this.getMovementSpeed()), (float)0.0f, (float)this.getExtensionRange());
        return interpolatedOffset;
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
        this.waitingForSpeedChange = false;
    }

    @Override
    public void func_145843_s() {
        this.field_145846_f = true;
        if (!this.field_145850_b.field_72995_K) {
            this.disassemble();
        }
        super.func_145843_s();
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Running", this.running);
        compound.func_74757_a("Waiting", this.waitingForSpeedChange);
        compound.func_74776_a("Offset", this.offset);
        super.write(compound, clientPacket);
        if (clientPacket && this.forceMove) {
            compound.func_74757_a("ForceMovement", this.forceMove);
            this.forceMove = false;
        }
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        boolean forceMovement = compound.func_74764_b("ForceMovement");
        float offsetBefore = this.offset;
        this.running = compound.func_74767_n("Running");
        this.waitingForSpeedChange = compound.func_74767_n("Waiting");
        this.offset = compound.func_74760_g("Offset");
        super.fromTag(state, compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (forceMovement) {
            this.applyContraptionPosition();
        } else if (this.running) {
            this.clientOffsetDiff = this.offset - offsetBefore;
            this.offset = offsetBefore;
        }
        if (!this.running) {
            this.movedContraption = null;
        }
    }

    public abstract void disassemble();

    protected abstract void assemble();

    protected abstract int getExtensionRange();

    protected abstract int getInitialOffset();

    protected abstract ValueBoxTransform getMovementModeSlot();

    protected abstract Vector3d toMotionVector(float var1);

    protected abstract Vector3d toPosition(float var1);

    protected void visitNewPosition() {
    }

    protected void tryDisassemble() {
        if (this.field_145846_f) {
            this.disassemble();
            return;
        }
        if (this.movementMode.get() == IControlContraption.MovementMode.MOVE_NEVER_PLACE) {
            this.waitingForSpeedChange = true;
            return;
        }
        int initial = this.getInitialOffset();
        if ((int)(this.offset + 0.5f) != initial && this.movementMode.get() == IControlContraption.MovementMode.MOVE_PLACE_RETURNED) {
            this.waitingForSpeedChange = true;
            return;
        }
        this.disassemble();
    }

    @Override
    public void collided() {
        if (this.field_145850_b.field_72995_K) {
            this.waitingForSpeedChange = true;
            return;
        }
        this.offset = this.getGridOffset(this.offset - this.getMovementSpeed());
        this.applyContraptionPosition();
        this.tryDisassemble();
    }

    protected void applyContraptionMotion() {
        if (this.movedContraption == null) {
            return;
        }
        if (this.movedContraption.isStalled()) {
            this.movedContraption.setContraptionMotion(Vector3d.field_186680_a);
            return;
        }
        this.movedContraption.setContraptionMotion(this.getMotionVector());
    }

    protected void applyContraptionPosition() {
        if (this.movedContraption == null) {
            return;
        }
        Vector3d vec = this.toPosition(this.offset);
        this.movedContraption.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        if (this.getSpeed() == 0.0f || this.waitingForSpeedChange) {
            this.movedContraption.setContraptionMotion(Vector3d.field_186680_a);
        }
    }

    public float getMovementSpeed() {
        float movementSpeed = this.getSpeed() / 512.0f + this.clientOffsetDiff / 2.0f;
        if (this.field_145850_b.field_72995_K) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }

    public Vector3d getMotionVector() {
        return this.toMotionVector(this.getMovementSpeed());
    }

    @Override
    public void onStall() {
        if (!this.field_145850_b.field_72995_K) {
            this.forceMove = true;
            this.sendData();
        }
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public void attach(ControlledContraptionEntity contraption) {
        this.movedContraption = contraption;
        if (!this.field_145850_b.field_72995_K) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity contraption) {
        return this.movedContraption == contraption;
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.field_174879_c;
    }
}

