/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public class CartAssemblerTileEntity
extends SmartTileEntity {
    private static final int assemblyCooldown = 8;
    protected ScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate = 8;

    public CartAssemblerTileEntity(TileEntityType<? extends CartAssemblerTileEntity> type) {
        super(type);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.ticksSinceMinecartUpdate < 8) {
            ++this.ticksSinceMinecartUpdate;
        }
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.movementMode = new ScrollOptionBehaviour<CartMovementMode>(CartMovementMode.class, (ITextComponent)Lang.translate("contraptions.cart_movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        behaviours.add(this.movementMode);
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new CartAssemblerValueBoxTransform();
    }

    public void resetTicksSinceMinecartUpdate() {
        this.ticksSinceMinecartUpdate = 0;
    }

    public boolean isMinecartUpdateValid() {
        return this.ticksSinceMinecartUpdate >= 8;
    }

    public static enum CartMovementMode implements INamedIconOptions
    {
        ROTATE(AllIcons.I_CART_ROTATE),
        ROTATE_PAUSED(AllIcons.I_CART_ROTATE_PAUSED),
        ROTATION_LOCKED(AllIcons.I_CART_ROTATE_LOCKED);

        private String translationKey;
        private AllIcons icon;

        private CartMovementMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.cart_movement_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class CartAssemblerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public CartAssemblerValueBoxTransform() {
            super((BlockState state, Direction d) -> {
                if (d.func_176740_k().func_200128_b()) {
                    return false;
                }
                if (!BlockHelper.hasBlockStateProperty(state, CartAssemblerBlock.RAIL_SHAPE)) {
                    return false;
                }
                RailShape railShape = (RailShape)state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE);
                return d.func_176740_k() == Direction.Axis.X == (railShape == RailShape.NORTH_SOUTH);
            });
        }

        @Override
        protected Vector3d getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 8.0, 18.0);
        }
    }
}

