/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ChassisRangeDisplay {
    private static final int DISPLAY_TIME = 200;
    private static GroupEntry lastHoveredGroup = null;
    static Map<BlockPos, Entry> entries = new HashMap<BlockPos, Entry>();
    static List<GroupEntry> groupEntries = new ArrayList<GroupEntry>();

    public static void tick() {
        GroupEntry existingGroupForPos;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        boolean hasWrench = AllItems.WRENCH.isIn(player.func_184614_ca());
        Iterator<Object> iterator = entries.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            Entry entry = entries.get(pos);
            if (ChassisRangeDisplay.tickEntry(entry, hasWrench)) {
                iterator.remove();
            }
            CreateClient.outliner.keep(entry.getOutlineKey());
        }
        iterator = groupEntries.iterator();
        while (iterator.hasNext()) {
            GroupEntry group = (GroupEntry)iterator.next();
            if (ChassisRangeDisplay.tickEntry(group, hasWrench)) {
                iterator.remove();
                if (group == lastHoveredGroup) {
                    lastHoveredGroup = null;
                }
            }
            CreateClient.outliner.keep(group.getOutlineKey());
        }
        if (!hasWrench) {
            return;
        }
        RayTraceResult over = Minecraft.func_71410_x().field_71476_x;
        if (!(over instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult ray = (BlockRayTraceResult)over;
        BlockPos pos = ray.func_216350_a();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || tileEntity.func_145837_r()) {
            return;
        }
        if (!(tileEntity instanceof ChassisTileEntity)) {
            return;
        }
        boolean ctrl = AllKeys.ctrlDown();
        ChassisTileEntity chassisTileEntity = (ChassisTileEntity)tileEntity;
        if (ctrl && (existingGroupForPos = ChassisRangeDisplay.getExistingGroupForPos(pos)) != null) {
            for (ChassisTileEntity included : existingGroupForPos.includedTEs) {
                entries.remove(included.func_174877_v());
            }
            existingGroupForPos.timer = 200;
            return;
        }
        if (!entries.containsKey(pos) || ctrl) {
            ChassisRangeDisplay.display(chassisTileEntity);
        } else if (!ctrl) {
            ChassisRangeDisplay.entries.get((Object)pos).timer = 200;
        }
    }

    private static boolean tickEntry(Entry entry, boolean hasWrench) {
        ChassisTileEntity chassisTileEntity = entry.te;
        World teWorld = chassisTileEntity.func_145831_w();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (chassisTileEntity.func_145837_r() || teWorld == null || teWorld != world || !world.func_195588_v(chassisTileEntity.func_174877_v())) {
            return true;
        }
        if (!hasWrench && entry.timer > 20) {
            entry.timer = 20;
            return false;
        }
        --entry.timer;
        return entry.timer == 0;
    }

    public static void display(ChassisTileEntity chassis) {
        if (AllKeys.ctrlDown()) {
            GroupEntry hoveredGroup = new GroupEntry(chassis);
            for (ChassisTileEntity included : hoveredGroup.includedTEs) {
                CreateClient.outliner.remove(included.func_174877_v());
            }
            groupEntries.forEach(entry -> CreateClient.outliner.remove(entry.getOutlineKey()));
            groupEntries.clear();
            entries.clear();
            groupEntries.add(hoveredGroup);
            return;
        }
        BlockPos pos = chassis.func_174877_v();
        GroupEntry entry2 = ChassisRangeDisplay.getExistingGroupForPos(pos);
        if (entry2 != null) {
            CreateClient.outliner.remove(entry2.getOutlineKey());
        }
        groupEntries.clear();
        entries.clear();
        entries.put(pos, new Entry(chassis));
    }

    private static GroupEntry getExistingGroupForPos(BlockPos pos) {
        for (GroupEntry groupEntry : groupEntries) {
            for (ChassisTileEntity chassis : groupEntry.includedTEs) {
                if (!pos.equals((Object)chassis.func_174877_v())) continue;
                return groupEntry;
            }
        }
        return null;
    }

    private static class GroupEntry
    extends Entry {
        List<ChassisTileEntity> includedTEs;

        public GroupEntry(ChassisTileEntity te) {
            super(te);
        }

        @Override
        protected Object getOutlineKey() {
            return this;
        }

        @Override
        protected Set<BlockPos> createSelection(ChassisTileEntity chassis) {
            HashSet<BlockPos> list = new HashSet<BlockPos>();
            this.includedTEs = this.te.collectChassisGroup();
            if (this.includedTEs == null) {
                return list;
            }
            for (ChassisTileEntity chassisTileEntity : this.includedTEs) {
                list.addAll(super.createSelection(chassisTileEntity));
            }
            return list;
        }
    }

    private static class Entry {
        ChassisTileEntity te;
        int timer;

        public Entry(ChassisTileEntity te) {
            this.te = te;
            this.timer = 200;
            CreateClient.outliner.showCluster(this.getOutlineKey(), this.createSelection(te)).colored(0xFFFFFF).disableNormals().lineWidth(0.0625f).withFaceTexture(AllSpecialTextures.HIGHLIGHT_CHECKERED);
        }

        protected Object getOutlineKey() {
            return Pair.of((Object)this.te.func_174877_v(), (Object)1);
        }

        protected Set<BlockPos> createSelection(ChassisTileEntity chassis) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(null, true);
            if (includedBlockPositions == null) {
                return Collections.emptySet();
            }
            positions.addAll(includedBlockPositions);
            return positions;
        }
    }
}

