/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.bearing;

import com.simibubi.create.content.contraptions.components.structureMovement.AllContraptionTypes;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StabilizedContraption
extends Contraption {
    private Direction facing;

    public StabilizedContraption() {
    }

    public StabilizedContraption(Direction facing) {
        this.facing = facing;
    }

    @Override
    public boolean assemble(World world, BlockPos pos) {
        BlockPos offset = pos.func_177972_a(this.facing);
        if (!this.searchMovedStructure(world, offset, null)) {
            return false;
        }
        this.startMoving(world);
        this.expandBoundsAroundAxis(Direction.Axis.Y);
        return !this.blocks.isEmpty();
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return false;
    }

    @Override
    protected AllContraptionTypes getType() {
        return AllContraptionTypes.STABILIZED;
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        tag.func_74768_a("Facing", this.facing.func_176745_a());
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag, boolean spawnData) {
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    @Override
    protected boolean canAxisBeStabilized(Direction.Axis axis) {
        return false;
    }

    public Direction getFacing() {
        return this.facing;
    }
}

