/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class ContraptionStallPacket
extends SimplePacketBase {
    int entityID;
    float x;
    float y;
    float z;
    float angle;

    public ContraptionStallPacket(int entityID, double posX, double posY, double posZ, float angle) {
        this.entityID = entityID;
        this.x = (float)posX;
        this.y = (float)posY;
        this.z = (float)posZ;
        this.angle = angle;
    }

    public ContraptionStallPacket(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.x = buffer.readFloat();
        this.y = buffer.readFloat();
        this.z = buffer.readFloat();
        this.angle = buffer.readFloat();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        this.writeAll(buffer, this.x, this.y, this.z, this.angle);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> AbstractContraptionEntity.handleStallPacket(this)));
        context.get().setPacketHandled(true);
    }

    private void writeAll(PacketBuffer buffer, float ... floats) {
        for (float f : floats) {
            buffer.writeFloat(f);
        }
    }
}

