/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.ClockworkContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyContraption;
import com.simibubi.create.foundation.utility.Lang;
import java.util.function.Supplier;

public enum AllContraptionTypes {
    PISTON(PistonContraption::new),
    BEARING(BearingContraption::new),
    PULLEY(PulleyContraption::new),
    CLOCKWORK(ClockworkContraption::new),
    MOUNTED(MountedContraption::new),
    STABILIZED(StabilizedContraption::new);

    Supplier<? extends Contraption> factory;
    String id;

    private AllContraptionTypes(Supplier<? extends Contraption> factory) {
        this.factory = factory;
        this.id = Lang.asId(this.name());
    }

    public static Contraption fromType(String type) {
        for (AllContraptionTypes allContraptionTypes : AllContraptionTypes.values()) {
            if (!type.equals(allContraptionTypes.id)) continue;
            return allContraptionTypes.factory.get();
        }
        return null;
    }
}

