/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;

public class FlywheelRenderer
extends KineticTileEntityRenderer {
    public FlywheelRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = te.func_195044_w();
        FlywheelTileEntity wte = (FlywheelTileEntity)te;
        SuperByteBuffer wheel = AllBlockPartials.FLYWHEEL.renderOnHorizontal(blockState.func_185907_a(Rotation.CLOCKWISE_90));
        float speed = wte.visualSpeed.get(partialTicks) * 3.0f / 10.0f;
        float angle = wte.angle + speed * partialTicks;
        IVertexBuilder vb = buffer.getBuffer(RenderType.func_228639_c_());
        if (FlywheelBlock.isConnected(blockState)) {
            Direction connection = FlywheelBlock.getConnection(blockState);
            light = WorldRenderer.func_228420_a_((IBlockDisplayReader)te.func_145831_w(), (BlockState)blockState, (BlockPos)te.func_174877_v().func_177972_a(connection));
            float rotation = connection.func_176740_k() == Direction.Axis.X ^ connection.func_176743_c() == Direction.AxisDirection.NEGATIVE ? -angle : angle;
            boolean flip = blockState.func_177229_b(FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
            this.transformConnector(this.rotateToFacing(AllBlockPartials.FLYWHEEL_UPPER_ROTATING.renderOn(blockState), connection), true, true, rotation, flip).light(light).renderInto(ms, vb);
            this.transformConnector(this.rotateToFacing(AllBlockPartials.FLYWHEEL_LOWER_ROTATING.renderOn(blockState), connection), false, true, rotation, flip).light(light).renderInto(ms, vb);
            this.transformConnector(this.rotateToFacing(AllBlockPartials.FLYWHEEL_UPPER_SLIDING.renderOn(blockState), connection), true, false, rotation, flip).light(light).renderInto(ms, vb);
            this.transformConnector(this.rotateToFacing(AllBlockPartials.FLYWHEEL_LOWER_SLIDING.renderOn(blockState), connection), false, false, rotation, flip).light(light).renderInto(ms, vb);
        }
        FlywheelRenderer.kineticRotationTransform(wheel, te, ((Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k(), AngleHelper.rad(angle), light);
        wheel.renderInto(ms, vb);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return AllBlockPartials.SHAFT_HALF.renderOnDirectionalSouth(te.func_195044_w(), ((Direction)te.func_195044_w().func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176734_d());
    }

    protected SuperByteBuffer transformConnector(SuperByteBuffer buffer, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = MathHelper.func_76126_a((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        buffer.translate(pivotX, pivotY, pivotZ + shifting);
        if (rotating) {
            buffer.rotate(Direction.EAST, AngleHelper.rad(barAngle));
        }
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        if (flip && !upper) {
            buffer.translate(0.5625f, 0.0f, 0.0f);
        }
        return buffer;
    }

    protected SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        buffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing)));
        return buffer;
    }
}

