/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFilterSlot;
import com.simibubi.create.content.contraptions.components.deployer.DeployerHandler;
import com.simibubi.create.content.contraptions.components.deployer.DeployerItemHandler;
import com.simibubi.create.content.curiosities.tools.SandPaperItem;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DeployerTileEntity
extends KineticTileEntity {
    protected State state;
    protected Mode mode;
    protected ItemStack heldItem = ItemStack.field_190927_a;
    protected DeployerFakePlayer player;
    protected int timer;
    protected float reach;
    protected boolean boop = false;
    protected List<ItemStack> overflowItems = new ArrayList<ItemStack>();
    protected FilteringBehaviour filtering;
    protected boolean redstoneLocked = false;
    private LazyOptional<IItemHandlerModifiable> invHandler;
    private ListNBT deferredInventoryList;

    public DeployerTileEntity(TileEntityType<? extends DeployerTileEntity> type) {
        super(type);
        this.state = State.WAITING;
        this.mode = Mode.USE;
        this.heldItem = ItemStack.field_190927_a;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new DeployerFilterSlot());
        behaviours.add(this.filtering);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.field_145850_b.field_72995_K) {
            this.player = new DeployerFakePlayer((ServerWorld)this.field_145850_b);
            if (this.deferredInventoryList != null) {
                this.player.field_71071_by.func_70443_b(this.deferredInventoryList);
                this.deferredInventoryList = null;
                this.heldItem = this.player.func_184614_ca();
                this.sendData();
            }
            Vector3d initialPos = VecHelper.getCenterOf((Vector3i)this.field_174879_c.func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)DirectionalKineticBlock.FACING)));
            this.player.func_70107_b(initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c);
        }
        this.invHandler = LazyOptional.of(this::createHandler);
    }

    protected void onExtract(ItemStack stack) {
        this.player.func_184611_a(Hand.MAIN_HAND, stack.func_77946_l());
        this.sendData();
        this.func_70296_d();
    }

    protected int getTimerSpeed() {
        return (int)(this.getSpeed() == 0.0f ? 0.0f : MathHelper.func_76131_a((float)Math.abs(this.getSpeed() * 2.0f), (float)8.0f, (float)512.0f));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.player != null && this.player.blockBreakingProgress != null && this.field_145850_b.func_175623_d((BlockPos)this.player.blockBreakingProgress.getKey())) {
            this.field_145850_b.func_175715_c(this.player.func_145782_y(), (BlockPos)this.player.blockBreakingProgress.getKey(), -1);
            this.player.blockBreakingProgress = null;
        }
        if (this.timer > 0) {
            this.timer -= this.getTimerSpeed();
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.player.func_184614_ca();
        if (this.state == State.WAITING) {
            if (!this.overflowItems.isEmpty()) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            boolean changed = false;
            for (int i = 0; i < this.player.field_71071_by.func_70302_i_() && this.overflowItems.size() <= 10; ++i) {
                ItemStack item = this.player.field_71071_by.func_70301_a(i);
                if (item.func_190926_b() || item == stack && this.filtering.test(item)) continue;
                this.overflowItems.add(item);
                this.player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                changed = true;
            }
            if (changed) {
                this.sendData();
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)DirectionalKineticBlock.FACING);
            if (this.mode == Mode.USE && !DeployerHandler.shouldActivate(stack, this.field_145850_b, this.field_174879_c.func_177967_a(facing, 2))) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            if (this.mode == Mode.PUNCH && !this.boop && this.startBoop(facing)) {
                return;
            }
            if (this.redstoneLocked) {
                return;
            }
            this.state = State.EXPANDING;
            Vector3d movementVector = this.getMovementVector();
            Vector3d rayOrigin = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_178787_e(movementVector.func_186678_a(1.5));
            Vector3d rayTarget = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_178787_e(movementVector.func_186678_a(2.5));
            RayTraceContext rayTraceContext = new RayTraceContext(rayOrigin, rayTarget, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.player);
            BlockRayTraceResult result = this.field_145850_b.func_217299_a(rayTraceContext);
            this.reach = (float)(0.5 + Math.min(result.func_216347_e().func_178788_d(rayOrigin).func_72433_c(), 0.75));
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.EXPANDING) {
            if (this.boop) {
                this.triggerBoop();
            } else {
                this.activate();
            }
            this.state = State.RETRACTING;
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.RETRACTING) {
            this.state = State.WAITING;
            this.timer = 500;
            this.sendData();
            return;
        }
    }

    public boolean startBoop(Direction facing) {
        if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177967_a(facing, 1)) || !this.field_145850_b.func_175623_d(this.field_174879_c.func_177967_a(facing, 2))) {
            return false;
        }
        BlockPos otherDeployer = this.field_174879_c.func_177967_a(facing, 4);
        if (!this.field_145850_b.func_195588_v(otherDeployer)) {
            return false;
        }
        TileEntity otherTile = this.field_145850_b.func_175625_s(otherDeployer);
        if (!(otherTile instanceof DeployerTileEntity)) {
            return false;
        }
        DeployerTileEntity deployerTile = (DeployerTileEntity)otherTile;
        if (((Direction)this.field_145850_b.func_180495_p(otherDeployer).func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176734_d() != facing || deployerTile.mode != Mode.PUNCH) {
            return false;
        }
        this.boop = true;
        this.reach = 1.0f;
        this.timer = 1000;
        this.state = State.EXPANDING;
        this.sendData();
        return true;
    }

    public void triggerBoop() {
        TileEntity otherTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)DirectionalKineticBlock.FACING), 4));
        if (!(otherTile instanceof DeployerTileEntity)) {
            return;
        }
        DeployerTileEntity deployerTile = (DeployerTileEntity)otherTile;
        if (!deployerTile.boop || deployerTile.state != State.EXPANDING) {
            return;
        }
        if (deployerTile.timer > 0) {
            return;
        }
        this.boop = false;
        deployerTile.boop = false;
        deployerTile.state = State.RETRACTING;
        deployerTile.timer = 1000;
        deployerTile.sendData();
        List players = this.field_145850_b.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(9.0));
        players.forEach(AllTriggers.DEPLOYER_BOOP::trigger);
    }

    protected void activate() {
        Vector3d movementVector = this.getMovementVector();
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)DirectionalKineticBlock.FACING);
        Vector3d center = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        BlockPos clickedPos = this.field_174879_c.func_177967_a(direction, 2);
        this.player.field_70177_z = direction.func_185119_l();
        this.player.field_70125_A = direction == Direction.UP ? -90.0f : (direction == Direction.DOWN ? 90.0f : 0.0f);
        DeployerHandler.activate(this.player, center, clickedPos, movementVector, this.mode);
        if (this.player != null) {
            this.heldItem = this.player.func_184614_ca();
        }
    }

    protected Vector3d getMovementVector() {
        if (!AllBlocks.DEPLOYER.has(this.func_195044_w())) {
            return Vector3d.field_186680_a;
        }
        return Vector3d.func_237491_b_((Vector3i)((Direction)this.func_195044_w().func_177229_b((Property)DirectionalKineticBlock.FACING)).func_176730_m());
    }

    @Override
    protected void fromTag(BlockState blockState, CompoundNBT compound, boolean clientPacket) {
        this.state = NBTHelper.readEnum(compound, "State", State.class);
        this.mode = NBTHelper.readEnum(compound, "Mode", Mode.class);
        this.timer = compound.func_74762_e("Timer");
        this.redstoneLocked = compound.func_74767_n("Powered");
        this.deferredInventoryList = compound.func_150295_c("Inventory", 10);
        this.overflowItems = NBTHelper.readItemList(compound.func_150295_c("Overflow", 10));
        if (compound.func_74764_b("HeldItem")) {
            this.heldItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("HeldItem"));
        }
        super.fromTag(blockState, compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.reach = compound.func_74760_g("Reach");
        if (compound.func_74764_b("Particle")) {
            ItemStack particleStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Particle"));
            SandPaperItem.spawnParticles(VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_178787_e(this.getMovementVector().func_186678_a(2.0)), particleStack, this.field_145850_b);
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        NBTHelper.writeEnum(compound, "Mode", this.mode);
        NBTHelper.writeEnum(compound, "State", this.state);
        compound.func_74768_a("Timer", this.timer);
        compound.func_74757_a("Powered", this.redstoneLocked);
        if (this.player != null) {
            compound.func_218657_a("HeldItem", (INBT)this.player.func_184614_ca().serializeNBT());
            ListNBT invNBT = new ListNBT();
            this.player.field_71071_by.func_70442_a(invNBT);
            compound.func_218657_a("Inventory", (INBT)invNBT);
            compound.func_218657_a("Overflow", (INBT)NBTHelper.writeItemList(this.overflowItems));
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        compound.func_74776_a("Reach", this.reach);
        if (this.player == null) {
            return;
        }
        compound.func_218657_a("HeldItem", (INBT)this.player.func_184614_ca().serializeNBT());
        if (this.player.spawnedItemEffects != null) {
            compound.func_218657_a("Particle", (INBT)this.player.spawnedItemEffects.serializeNBT());
            this.player.spawnedItemEffects = null;
        }
    }

    private IItemHandlerModifiable createHandler() {
        return new DeployerItemHandler(this);
    }

    public void redstoneUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean blockPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
    }

    public AllBlockPartials getHandPose() {
        return this.mode == Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : (this.heldItem.func_190926_b() ? AllBlockPartials.DEPLOYER_HAND_POINTING : AllBlockPartials.DEPLOYER_HAND_HOLDING);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(3.0);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void changeMode() {
        this.mode = this.mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        this.func_70296_d();
        this.sendData();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap) && this.invHandler != null) {
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean addToTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.overflowItems.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.full_deployer", new Object[0]);
        return true;
    }

    static enum Mode {
        PUNCH,
        USE;

    }

    static enum State {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

    }
}

