/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crusher;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingInventory;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CrushingWheelControllerTileEntity
extends SmartTileEntity {
    public Entity processingEntity;
    private UUID entityUUID;
    protected boolean searchForEntity;
    public ProcessingInventory inventory;
    protected LazyOptional<IItemHandlerModifiable> handler = LazyOptional.of(() -> this.inventory);
    private RecipeWrapper wrapper;
    public float crushingspeed;

    public CrushingWheelControllerTileEntity(TileEntityType<? extends CrushingWheelControllerTileEntity> type) {
        super(type);
        this.inventory = new ProcessingInventory(this::itemInserted){

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return super.isItemValid(slot, stack) && CrushingWheelControllerTileEntity.this.processingEntity == null;
            }
        };
        this.wrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.searchForEntity) {
            this.searchForEntity = false;
            List search = this.field_145850_b.func_175674_a(null, new AxisAlignedBB(this.func_174877_v()), e -> this.entityUUID.equals(e.func_110124_au()));
            if (search.isEmpty()) {
                this.clear();
            } else {
                this.processingEntity = (Entity)search.get(0);
            }
        }
        if (!this.isOccupied()) {
            return;
        }
        if (this.crushingspeed == 0.0f) {
            return;
        }
        float speed = this.crushingspeed * 4.0f;
        Vector3d outPos = VecHelper.getCenterOf((Vector3i)this.field_174879_c);
        if (!this.hasEntity()) {
            float processingSpeed = MathHelper.func_76131_a((float)(speed / (float)(!this.inventory.appliedRecipe ? MathHelper.func_151239_c((int)this.inventory.getStackInSlot(0).func_190916_E()) : 1)), (float)0.25f, (float)20.0f);
            this.inventory.remainingTime -= processingSpeed;
            this.spawnParticles(this.inventory.getStackInSlot(0));
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.inventory.remainingTime < 20.0f && !this.inventory.appliedRecipe) {
                this.applyRecipe();
                this.inventory.appliedRecipe = true;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 18);
                return;
            }
            if (this.inventory.remainingTime <= 0.0f) {
                for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                    ItemStack stack = this.inventory.getStackInSlot(slot);
                    if (stack.func_190926_b()) continue;
                    ItemEntity entityIn = new ItemEntity(this.field_145850_b, outPos.field_72450_a, outPos.field_72448_b, outPos.field_72449_c, stack);
                    entityIn.func_213317_d(Vector3d.field_186680_a);
                    entityIn.getPersistentData().func_218657_a("BypassCrushingWheel", (INBT)NBTUtil.func_186859_a((BlockPos)this.field_174879_c));
                    this.field_145850_b.func_217376_c((Entity)entityIn);
                }
                this.inventory.clear();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 18);
                return;
            }
            return;
        }
        if (!this.processingEntity.func_70089_S() || !this.processingEntity.func_174813_aQ().func_72326_a(new AxisAlignedBB(this.field_174879_c).func_186662_g(0.5))) {
            this.clear();
            return;
        }
        double xMotion = ((double)((float)this.field_174879_c.func_177958_n() + 0.5f) - this.processingEntity.func_226277_ct_()) / 2.0;
        double zMotion = ((double)((float)this.field_174879_c.func_177952_p() + 0.5f) - this.processingEntity.func_226281_cx_()) / 2.0;
        if (this.processingEntity.func_225608_bj_()) {
            zMotion = 0.0;
            xMotion = 0.0;
        }
        this.processingEntity.func_213317_d(new Vector3d(xMotion, (double)Math.max(-speed / 4.0f, -0.5f), zMotion));
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.processingEntity instanceof ItemEntity)) {
            this.processingEntity.func_70097_a(CrushingWheelTileEntity.damageSource, (float)((Integer)AllConfigs.SERVER.kinetics.crushingDamage.get()).intValue());
            if (!this.processingEntity.func_70089_S()) {
                this.processingEntity.func_70107_b(outPos.field_72450_a, outPos.field_72448_b - 0.75, outPos.field_72449_c);
            }
            return;
        }
        ItemEntity itemEntity = (ItemEntity)this.processingEntity;
        itemEntity.func_174867_a(20);
        if (this.processingEntity.func_226278_cu_() < (double)((float)this.field_174879_c.func_177956_o() + 0.25f)) {
            this.inventory.clear();
            this.inventory.setStackInSlot(0, itemEntity.func_92059_d().func_77946_l());
            this.itemInserted(this.inventory.getStackInSlot(0));
            itemEntity.func_70106_y();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 18);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        Object particleData = null;
        particleData = stack.func_77973_b() instanceof BlockItem ? new BlockParticleData(ParticleTypes.field_197611_d, ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P()) : new ItemParticleData(ParticleTypes.field_197591_B, stack);
        Random r = this.field_145850_b.field_73012_v;
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)particleData, (double)((float)this.field_174879_c.func_177958_n() + r.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + r.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + r.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    private void applyRecipe() {
        Optional<ProcessingRecipe<RecipeWrapper>> recipe = this.findRecipe();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (recipe.isPresent()) {
            int rolls = this.inventory.getStackInSlot(0).func_190916_E();
            this.inventory.clear();
            for (int roll = 0; roll < rolls; ++roll) {
                List<ItemStack> rolledResults = recipe.get().rollResults();
                for (int i = 0; i < rolledResults.size(); ++i) {
                    ItemStack stack = rolledResults.get(i);
                    ItemHelper.addToList(stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
        } else {
            this.inventory.clear();
        }
    }

    public Optional<ProcessingRecipe<RecipeWrapper>> findRecipe() {
        Optional<ProcessingRecipe<Object>> crushingRecipe = AllRecipeTypes.CRUSHING.find(this.wrapper, this.field_145850_b);
        if (!crushingRecipe.isPresent()) {
            crushingRecipe = AllRecipeTypes.MILLING.find(this.wrapper, this.field_145850_b);
        }
        return crushingRecipe;
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (this.hasEntity()) {
            compound.func_218657_a("Entity", (INBT)NBTUtil.func_240626_a_((UUID)this.entityUUID));
        }
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74776_a("Speed", this.crushingspeed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        if (compound.func_74764_b("Entity") && !this.isOccupied()) {
            this.entityUUID = NBTUtil.func_186860_b((INBT)NBTHelper.getINBT(compound, "Entity"));
            this.searchForEntity = true;
        }
        this.crushingspeed = compound.func_74760_g("Speed");
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
    }

    public void startCrushing(Entity entity) {
        this.processingEntity = entity;
        this.entityUUID = entity.func_110124_au();
    }

    private void itemInserted(ItemStack stack) {
        Optional<ProcessingRecipe<RecipeWrapper>> recipe = this.findRecipe();
        this.inventory.remainingTime = recipe.isPresent() ? (float)recipe.get().getProcessingDuration() : 100.0f;
        this.inventory.appliedRecipe = false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void clear() {
        this.processingEntity = null;
        this.entityUUID = null;
    }

    public boolean isOccupied() {
        return this.hasEntity() || !this.inventory.isEmpty();
    }

    public boolean hasEntity() {
        return this.processingEntity != null;
    }
}

