/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.actors.HarvesterRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class HarvesterMovementBehaviour
extends MovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d());
    }

    @Override
    public void renderInContraption(MovementContext context, MatrixStack ms, MatrixStack msLocal, IRenderTypeBuffer buffers) {
        HarvesterRenderer.renderInContraption(context, ms, msLocal, buffers);
    }

    @Override
    public Vector3d getActiveAreaOffset(MovementContext context) {
        return Vector3d.func_237491_b_((Vector3i)((Direction)context.state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176730_m()).func_186678_a(0.45);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        World world = context.world;
        BlockState stateVisited = world.func_180495_p(pos);
        boolean notCropButCuttable = false;
        if (world.field_72995_K) {
            return;
        }
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockState state = stateVisited;
        BlockHelper.destroyBlock(world, pos, 1.0f, stack -> {
            if (!seedSubtracted.getValue().booleanValue() && stack.func_77969_a(new ItemStack((IItemProvider)state.func_177230_c()))) {
                stack.func_190918_g(1);
                seedSubtracted.setTrue();
            }
            this.dropItem(context, (ItemStack)stack);
        });
        world.func_175656_a(pos, this.cutCrop(world, pos, stateVisited));
    }

    private boolean isValidCrop(World world, BlockPos pos, BlockState state) {
        if (state.func_177230_c() instanceof CropsBlock) {
            CropsBlock crop = (CropsBlock)state.func_177230_c();
            return crop.func_185525_y(state);
        }
        if (state.func_196952_d((IBlockReader)world, pos).func_197766_b() || state.func_177230_c() instanceof CocoaBlock) {
            for (Property property : state.func_235904_r_()) {
                if (!(property instanceof IntegerProperty) || !property.func_177701_a().equals(BlockStateProperties.field_222512_Y.func_177701_a()) || ((IntegerProperty)property).func_177700_c().size() - 1 != (Integer)state.func_177229_b((Property)((IntegerProperty)property))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValidOther(World world, BlockPos pos, BlockState state) {
        if (state.func_177230_c() instanceof CropsBlock) {
            return false;
        }
        if (state.func_177230_c() instanceof SugarCaneBlock) {
            return true;
        }
        if (state.func_196952_d((IBlockReader)world, pos).func_197766_b() || state.func_177230_c() instanceof CocoaBlock) {
            if (state.func_177230_c() instanceof KelpBlock) {
                return true;
            }
            if (state.func_177230_c() instanceof KelpTopBlock) {
                return true;
            }
            for (Property property : state.func_235904_r_()) {
                if (!(property instanceof IntegerProperty) || !property.func_177701_a().equals(BlockStateProperties.field_222512_Y.func_177701_a())) continue;
                return false;
            }
            if (state.func_177230_c() instanceof IPlantable) {
                return true;
            }
        }
        return false;
    }

    private BlockState cutCrop(World world, BlockPos pos, BlockState state) {
        if (state.func_177230_c() instanceof CropsBlock) {
            CropsBlock crop = (CropsBlock)state.func_177230_c();
            return crop.func_185528_e(0);
        }
        if (state.func_177230_c() == Blocks.field_196608_cF || state.func_177230_c() == Blocks.field_203214_jx) {
            if (state.func_204520_s().func_206888_e()) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return state.func_204520_s().func_206883_i();
        }
        if (state.func_196952_d((IBlockReader)world, pos).func_197766_b() || state.func_177230_c() instanceof CocoaBlock) {
            for (Property property : state.func_235904_r_()) {
                if (!(property instanceof IntegerProperty) || !property.func_177701_a().equals(BlockStateProperties.field_222512_Y.func_177701_a())) continue;
                return (BlockState)state.func_206870_a((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.func_204520_s().func_206888_e()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state.func_204520_s().func_206883_i();
    }
}

