/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.KineticNetwork;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class GeneratingKineticTileEntity
extends KineticTileEntity {
    public boolean reActivateSource;

    public GeneratingKineticTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    protected void notifyStressCapacityChange(float capacity) {
        this.getOrCreateNetwork().updateCapacityFor(this, capacity);
    }

    @Override
    public void removeSource() {
        if (this.hasSource() && this.isSource()) {
            this.reActivateSource = true;
        }
        super.removeSource();
    }

    @Override
    public void setSource(BlockPos source) {
        super.setSource(source);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(source);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return;
        }
        KineticTileEntity sourceTe = (KineticTileEntity)tileEntity;
        if (this.reActivateSource && sourceTe != null && Math.abs(sourceTe.getSpeed()) >= Math.abs(this.getGeneratedSpeed())) {
            this.reActivateSource = false;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressBase = this.calculateAddedStressCapacity();
        if (stressBase != 0.0f && IRotate.StressImpact.isEnabled()) {
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)Lang.translate("gui.goggles.generator_stats", new Object[0])));
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)Lang.translate("tooltip.capacityProvided", new Object[0]).func_240699_a_(TextFormatting.GRAY)));
            float speed = this.getTheoreticalSpeed();
            if (speed != this.getGeneratedSpeed() && speed != 0.0f) {
                stressBase *= this.getGeneratedSpeed() / speed;
            }
            speed = Math.abs(speed);
            float stressTotal = stressBase * speed;
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new StringTextComponent(" " + IHaveGoggleInformation.format(stressTotal)).func_230529_a_((ITextComponent)Lang.translate("generic.unit.stress", new Object[0])).func_240702_b_(" ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)Lang.translate("gui.goggles.at_current_speed", new Object[0]).func_240699_a_(TextFormatting.DARK_GRAY)));
            added = true;
        }
        return added;
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of(this.speed)) != (levelafter = IRotate.SpeedLevel.of(speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor(this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        if (speed == 0.0f) {
            if (this.hasSource()) {
                this.notifyStressCapacityChange(0.0f);
                this.getOrCreateNetwork().updateStressFor(this, this.calculateStressApplied());
                return;
            }
            this.detachKinetics();
            this.setSpeed(0.0f);
            this.setNetwork(null);
            return;
        }
        if (prevSpeed == 0.0f) {
            this.setSpeed(speed);
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
            return;
        }
        if (this.hasSource()) {
            if (Math.abs(prevSpeed) >= Math.abs(speed)) {
                if (Math.signum(prevSpeed) != Math.signum(speed)) {
                    this.field_145850_b.func_175655_b(this.field_174879_c, true);
                }
                return;
            }
            this.detachKinetics();
            this.setSpeed(speed);
            this.source = null;
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
            return;
        }
        this.detachKinetics();
        this.setSpeed(speed);
        this.attachKinetics();
    }

    public Long createNetworkId() {
        return this.field_174879_c.func_218275_a();
    }
}

