/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllFluids;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public abstract class CreateRecipeCategory<T extends IRecipe<?>>
implements IRecipeCategory<T> {
    public List<Supplier<? extends Object>> recipeCatalysts = new ArrayList<Supplier<? extends Object>>();
    public List<Supplier<List<? extends IRecipe<?>>>> recipes = new ArrayList();
    public ResourceLocation uid;
    protected String name;
    private IDrawable icon;
    private IDrawable background;

    public CreateRecipeCategory(IDrawable icon, IDrawable background) {
        this.background = background;
        this.icon = icon;
    }

    public void setCategoryId(String name) {
        this.uid = new ResourceLocation("create", name);
        this.name = name;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return Lang.translate("recipe." + this.name, new Object[0]).getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    protected static AllGuiTextures getRenderedSlot(IRecipe<?> recipe, int index) {
        AllGuiTextures jeiSlot = AllGuiTextures.JEI_SLOT;
        if (!(recipe instanceof ProcessingRecipe)) {
            return jeiSlot;
        }
        ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
        NonNullList<ProcessingOutput> rollableResults = processingRecipe.getRollableResults();
        if (rollableResults.size() <= index) {
            return jeiSlot;
        }
        if (((ProcessingOutput)processingRecipe.getRollableResults().get(index)).getChance() == 1.0f) {
            return jeiSlot;
        }
        return AllGuiTextures.JEI_CHANCE_SLOT;
    }

    protected static IDrawable emptyBackground(int width, int height) {
        return new EmptyBackground(width, height);
    }

    protected static IDrawable doubleItemIcon(IItemProvider item1, IItemProvider item2) {
        return new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2));
    }

    protected static IDrawable itemIcon(IItemProvider item) {
        return new DoubleItemIcon(() -> new ItemStack(item), () -> ItemStack.field_190927_a);
    }

    protected static void addStochasticTooltip(IGuiItemStackGroup itemStacks, List<ProcessingOutput> results) {
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                return;
            }
            ProcessingOutput output = (ProcessingOutput)results.get(slotIndex - 1);
            float chance = output.getChance();
            if (chance != 1.0f) {
                tooltip.add(1, Lang.translate("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).func_240699_a_(TextFormatting.GOLD));
            }
        });
    }

    public List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(this::withImprovedVisibility).collect(Collectors.toList());
    }

    public FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        int displayedAmount = (int)((float)stack.getAmount() * 0.75f) + 250;
        display.setAmount(displayedAmount);
        return display;
    }

    protected static void addFluidTooltip(IGuiFluidStackGroup fluidStacks, List<FluidIngredient> inputs, List<FluidStack> outputs) {
        ArrayList amounts = new ArrayList();
        inputs.forEach(f -> amounts.add(f.getRequiredAmount()));
        outputs.forEach(f -> amounts.add(f.getAmount()));
        fluidStacks.addTooltipCallback((slotIndex, input, fluid, tooltip) -> {
            if (fluid.getFluid().func_207187_a((Fluid)AllFluids.POTION.get())) {
                ITextComponent name = PotionFluidHandler.getPotionName(fluid);
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList<ITextComponent> potionTooltip = new ArrayList<ITextComponent>();
                PotionFluidHandler.addPotionTooltip(fluid, potionTooltip, 1.0f);
                tooltip.addAll(1, potionTooltip.stream().collect(Collectors.toList()));
            }
            int amount = (Integer)amounts.get(slotIndex);
            IFormattableTextComponent text = Lang.translate("generic.unit.millibuckets", amount).func_240699_a_(TextFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((ITextComponent)tooltip.get(0)).func_150253_a();
                siblings.add(new StringTextComponent(" "));
                siblings.add(text);
            }
        });
    }
}

