/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateContainer;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateScreen;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.item.filter.FilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterScreen;
import com.simibubi.create.content.schematics.block.SchematicTableContainer;
import com.simibubi.create.content.schematics.block.SchematicTableScreen;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonScreen;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.network.IContainerFactory;

public enum AllContainerTypes {
    SCHEMATIC_TABLE(SchematicTableContainer::new),
    SCHEMATICANNON(SchematicannonContainer::new),
    FLEXCRATE(AdjustableCrateContainer::new),
    FILTER(FilterContainer::new),
    ATTRIBUTE_FILTER(AttributeFilterContainer::new);

    public ContainerType<? extends Container> type;
    private ContainerType.IFactory<?> factory;

    private <C extends Container> AllContainerTypes(IContainerFactory<C> factory) {
        this.factory = factory;
    }

    public static void register(RegistryEvent.Register<ContainerType<?>> event) {
        for (AllContainerTypes container : AllContainerTypes.values()) {
            container.type = (ContainerType)new ContainerType(container.factory).setRegistryName(new ResourceLocation("create", Lang.asId(container.name())));
            event.getRegistry().register(container.type);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreenFactories() {
        AllContainerTypes.bind(SCHEMATIC_TABLE, SchematicTableScreen::new);
        AllContainerTypes.bind(SCHEMATICANNON, SchematicannonScreen::new);
        AllContainerTypes.bind(FLEXCRATE, AdjustableCrateScreen::new);
        AllContainerTypes.bind(FILTER, FilterScreen::new);
        AllContainerTypes.bind(ATTRIBUTE_FILTER, AttributeFilterScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <C extends Container, S extends Screen> void bind(AllContainerTypes c, ScreenManager.IScreenFactory<C, S> factory) {
        ScreenManager.func_216911_a(c.type, factory);
    }
}

