/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.enchdesc.jei.EnchantmentInfoEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class CategoryEnchantmentInfo
implements IRecipeCategory<EnchantmentInfoEntry> {
    public static final ResourceLocation ID = new ResourceLocation("enchdesc", "compatible_items");
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final IDrawableStatic slotDrawable;

    public CategoryEnchantmentInfo(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_151134_bR));
        this.background = guiHelper.createBlankDrawable(133, 48);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"enchdesc.jei.compatible_items.title", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends EnchantmentInfoEntry> getRecipeClass() {
        return EnchantmentInfoEntry.class;
    }

    public void setIngredients(EnchantmentInfoEntry info, IIngredients ingredients) {
        info.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout layout, EnchantmentInfoEntry recipe, IIngredients ingredients) {
        int slotId;
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List<List> slotContents = Arrays.asList(NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a(), NonNullList.func_191196_a());
        for (slotId = 0; slotId < recipe.getCompatibleItems().size() && slotId < recipe.getCompatibleItems().size(); ++slotId) {
            slotContents.get(slotId % slotContents.size()).add(recipe.getCompatibleItems().get(slotId));
        }
        for (slotId = 0; slotId < slotContents.size(); ++slotId) {
            stacks.init(slotId, false, 19 * (slotId % 7), 19 * (1 + slotId / 7) - 8);
            stacks.set(slotId, slotContents.get(slotId));
        }
        stacks.addTooltipCallback(recipe::getTooltip);
    }

    public void draw(EnchantmentInfoEntry info, MatrixStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderUtils.renderLinesWrapped((MatrixStack)matrix, (FontRenderer)minecraft.field_71466_p, (int)0, (int)0, (int)0, (int)0xFFFFFF, (ITextComponent)info.getName(), (int)130);
        for (int slotId = 0; slotId < 14; ++slotId) {
            this.slotDrawable.draw(matrix, 19 * (slotId % 7), 19 * (1 + slotId / 7) - 8);
        }
    }
}

