/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.reflection;

import hellfirepvp.astralsorcery.common.util.reflection.ReflectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.shapes.VoxelShapeSpliterator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ReflectionHelper {
    private static BiConsumer<ItemEntity, Boolean> itemEntitySkipPhysicRenderer;
    private static BiConsumer<VoxelShapeSpliterator, Boolean> voxelShapeIteratorDidCustomCollision;

    public static void setSkipItemPhysicsRender(ItemEntity entity) {
        if (itemEntitySkipPhysicRenderer == null) {
            itemEntitySkipPhysicRenderer = ReflectionHelper.getFieldSetter(ItemEntity.class, "skipPhysicRenderer", Field::setBoolean);
        }
        itemEntitySkipPhysicRenderer.accept(entity, true);
    }

    public static void setVoxelShapeIteratorDidCustomCollision(VoxelShapeSpliterator iterator) {
        if (voxelShapeIteratorDidCustomCollision == null) {
            voxelShapeIteratorDidCustomCollision = ReflectionHelper.getFieldSetter(VoxelShapeSpliterator.class, "as_didCustomCollision", Field::setBoolean);
        }
        voxelShapeIteratorDidCustomCollision.accept(iterator, true);
    }

    private static <T, V> BiConsumer<T, V> getFieldSetter(Class<T> owningClass, String fieldName, FieldSetter<T, V> fieldSetter) {
        Field field = ReflectionHelper.findField(owningClass, fieldName);
        if (field == null) {
            return (object, value) -> {};
        }
        return (object, value) -> {
            try {
                fieldSetter.setFieldValue(field, object, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    @Nullable
    private static <T> Field findField(Class<T> owningClass, String fieldName) {
        try {
            return ObfuscationReflectionHelper.findField(owningClass, (String)fieldName);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Function<Object[], Object> resolveConstructor(Class<?> owningClass, Class<?> ... parameters) {
        return invokeParams -> {
            try {
                Constructor ctor = owningClass.getDeclaredConstructor(parameters);
                ctor.setAccessible(true);
                return ctor.newInstance(invokeParams);
            }
            catch (Exception e) {
                throw new ReflectionException("Failed to resolve/call Constructor!", e);
            }
        };
    }

    private static BiFunction<Object, Object[], Object> resolveMethod(Class<?> owningClass, String methodName, Class<?> ... parameters) {
        return (owningObject, invokeParams) -> {
            try {
                Method m = owningClass.getDeclaredMethod(methodName, parameters);
                m.setAccessible(true);
                return m.invoke(owningObject, invokeParams);
            }
            catch (Exception e) {
                throw new ReflectionException("Failed to resolve/call Method!", e);
            }
        };
    }

    private static interface FieldSetter<T, V> {
        public void setFieldValue(Field var1, T var2, V var3) throws IllegalAccessException;
    }
}

