/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import com.mojang.datafixers.util.Either;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockStateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SimpleBlockPredicate
implements BlockPredicate,
Predicate<BlockState> {
    final Either<List<BlockState>, Block> validMatch;

    public SimpleBlockPredicate(Block block) {
        this.validMatch = Either.right((Object)block);
    }

    public SimpleBlockPredicate(BlockState ... states) {
        this.validMatch = Either.left(Arrays.asList(states));
    }

    public List<String> getAsConfigList() {
        ArrayList<String> out = new ArrayList<String>();
        this.validMatch.ifLeft(states -> states.stream().map(BlockStateHelper::serialize).forEach(out::add)).ifRight(block -> out.add(BlockStateHelper.serialize(block)));
        return out;
    }

    @Nullable
    public static SimpleBlockPredicate fromConfig(String serialized) {
        if (BlockStateHelper.isMissingStateInformation(serialized)) {
            Block b = BlockStateHelper.deserializeBlock(serialized);
            if (b != Blocks.field_150350_a) {
                return new SimpleBlockPredicate(b);
            }
        } else {
            BlockState state = BlockStateHelper.deserialize(serialized);
            if (state.func_177230_c() != Blocks.field_150350_a) {
                return new SimpleBlockPredicate(state);
            }
        }
        return null;
    }

    @Override
    public boolean test(BlockState state) {
        Either matchResult = this.validMatch.mapBoth(states -> states.contains(state), block -> state.func_177230_c().equals(block));
        return matchResult.left().orElse(matchResult.right().orElse(false));
    }

    @Override
    public boolean test(World world, BlockPos pos, BlockState state) {
        return this.test(state);
    }
}

