/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicate;
import hellfirepvp.astralsorcery.common.util.block.BlockPredicates;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockDiscoverer {
    public static Set<BlockPos> discoverBlocksWithSameStateAroundChain(World world, BlockPos origin, BlockState match, int length, @Nullable Direction originalBreakDirection, BlockPredicate addCheck) {
        HashSet<BlockPos> out = new HashSet<BlockPos>();
        BlockPos offset = new BlockPos((Vector3i)origin);
        block0: while (length > 0) {
            ArrayList faces = new ArrayList();
            Collections.addAll(faces, Direction.values());
            if (originalBreakDirection != null && out.isEmpty()) {
                faces.remove(originalBreakDirection);
                faces.remove(originalBreakDirection.func_176734_d());
            }
            Collections.shuffle(faces);
            for (Direction face : faces) {
                BlockState test;
                BlockPos at = offset.func_177972_a(face);
                if (out.contains(at) || !BlockUtils.matchStateExact(match, test = world.func_180495_p(at)) || !addCheck.test(world, at, test)) continue;
                out.add(at);
                --length;
                offset = at;
                continue block0;
            }
        }
        return out;
    }

    public static Set<BlockPos> searchForTileEntitiesAround(World world, BlockPos origin, int distance, Predicate<TileEntity> match) {
        HashSet<BlockPos> out = new HashSet<BlockPos>();
        int minChX = origin.func_177958_n() - distance >> 4;
        int minChZ = origin.func_177952_p() - distance >> 4;
        int maxChX = origin.func_177958_n() + distance >> 4;
        int maxChZ = origin.func_177952_p() + distance >> 4;
        for (int chX = minChX; chX <= maxChX; ++chX) {
            for (int chZ = minChZ; chZ <= maxChZ; ++chZ) {
                Chunk ch = world.func_212866_a_(chX, chZ);
                if (ch == null) continue;
                out.addAll(ch.func_177434_r().values().stream().filter(tile -> tile.func_174877_v().func_218141_a((Vector3i)origin, (double)distance)).filter(match).map(TileEntity::func_174877_v).collect(Collectors.toList()));
            }
        }
        return out;
    }

    public static List<BlockPos> searchForBlocksAround(World world, BlockPos origin, int cubeSize, BlockPredicate match) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        BlockPos.Mutable offset = new BlockPos.Mutable();
        for (int xx = -cubeSize; xx <= cubeSize; ++xx) {
            for (int zz = -cubeSize; zz <= cubeSize; ++zz) {
                for (int yy = -cubeSize; yy <= cubeSize; ++yy) {
                    offset.func_181079_c(origin.func_177958_n() + xx, origin.func_177956_o() + yy, origin.func_177952_p() + zz);
                    MiscUtils.executeWithChunk((IWorldReader)world, (BlockPos)offset, () -> {
                        BlockState atState = world.func_180495_p((BlockPos)offset);
                        if (match.test(world, (BlockPos)offset, atState)) {
                            out.add(new BlockPos((Vector3i)offset));
                        }
                    });
                }
            }
        }
        return out;
    }

    @Nullable
    public static BlockPos searchAreaForFirst(World world, BlockPos center, int radius, @Nullable Vector3 offsetFrom, BlockPredicate acceptor) {
        for (int r = 0; r <= radius; ++r) {
            HashSet posList = new HashSet();
            for (int xx = -r; xx <= r; ++xx) {
                for (int yy = -r; yy <= r; ++yy) {
                    for (int zz = -r; zz <= r; ++zz) {
                        BlockPos pos = center.func_177982_a(xx, yy, zz);
                        MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                            BlockState state = world.func_180495_p(pos);
                            if (acceptor.test(world, pos, state)) {
                                posList.add(pos);
                            }
                        });
                    }
                }
            }
            if (posList.isEmpty()) continue;
            Vector3 offset = new Vector3((Vector3i)center).add(0.5, 0.5, 0.5);
            if (offsetFrom != null) {
                offset = offsetFrom;
            }
            BlockPos closest = null;
            double prevDst = 0.0;
            for (BlockPos pos : posList) {
                if (closest != null && !(offset.distance((Vector3i)pos) < prevDst)) continue;
                closest = pos;
                prevDst = offset.distance((Vector3i)pos);
            }
            return closest;
        }
        return null;
    }

    public static List<BlockPos> discoverBlocksWithSameStateAround(World world, BlockPos origin, boolean onlyExposed, int cubeSize, int limit, boolean searchCorners) {
        return MiscUtils.executeWithChunk((IWorldReader)world, origin, () -> {
            BlockState state = world.func_180495_p(origin);
            return BlockDiscoverer.discoverBlocksWithSameStateAround(BlockPredicates.isState(state), world, origin, onlyExposed, cubeSize, limit, searchCorners);
        }, Lists.newArrayList());
    }

    public static List<BlockPos> discoverBlocksWithSameStateAround(BlockPredicate match, World world, BlockPos origin, boolean onlyExposed, int cubeSize, int limit, boolean searchCorners) {
        ArrayList<BlockPos> foundResult = new ArrayList<BlockPos>();
        foundResult.add(origin);
        LinkedList<BlockPos> visited = new LinkedList<BlockPos>();
        LinkedList<BlockPos> searchNext = new LinkedList<BlockPos>();
        searchNext.addFirst(origin);
        while (!searchNext.isEmpty()) {
            LinkedList<BlockPos> currentSearch = searchNext;
            searchNext = new LinkedList();
            for (BlockPos offsetPos : currentSearch) {
                if (searchCorners) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int yy = -1; yy <= 1; ++yy) {
                            for (int zz = -1; zz <= 1; ++zz) {
                                BlockPos search = offsetPos.func_177982_a(xx, yy, zz);
                                if (visited.contains(search) || BlockDiscoverer.getCubeDistance(search, origin) > cubeSize || limit != -1 && foundResult.size() + 1 > limit) continue;
                                visited.add(search);
                                if (onlyExposed && !BlockDiscoverer.isExposedToAir(world, search)) continue;
                                MiscUtils.executeWithChunk((IWorldReader)world, search, searchNext, searchQueue -> {
                                    if (match.test(world, search, world.func_180495_p(search))) {
                                        foundResult.add(search);
                                        searchQueue.add(search);
                                    }
                                });
                            }
                        }
                    }
                    continue;
                }
                for (Direction face : Direction.values()) {
                    BlockPos search = offsetPos.func_177972_a(face);
                    if (visited.contains(search) || BlockDiscoverer.getCubeDistance(search, origin) > cubeSize || limit != -1 && foundResult.size() + 1 > limit) continue;
                    visited.add(search);
                    if (onlyExposed && !BlockDiscoverer.isExposedToAir(world, search)) continue;
                    MiscUtils.executeWithChunk((IWorldReader)world, search, searchNext, searchQueue -> {
                        if (match.test(world, search, world.func_180495_p(search))) {
                            foundResult.add(search);
                            searchQueue.add(search);
                        }
                    });
                }
            }
        }
        return foundResult;
    }

    private static int getCubeDistance(BlockPos p1, BlockPos p2) {
        return (int)MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(p1.func_177958_n() - p2.func_177958_n()), (double)(p1.func_177956_o() - p2.func_177956_o())), (double)(p1.func_177952_p() - p2.func_177952_p()));
    }

    private static boolean isExposedToAir(World world, BlockPos pos) {
        for (Direction face : Direction.values()) {
            BlockPos offset = pos.func_177972_a(face);
            if (!MiscUtils.executeWithChunk((IWorldReader)world, offset, () -> BlockUtils.isReplaceable(world, offset), false).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

