/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import javax.annotation.Nullable;

public interface ServerLifecycleListener {
    public void onServerStart();

    public void onServerStop();

    public static ServerLifecycleListener stop(Runnable onStop) {
        return ServerLifecycleListener.wrap(null, onStop);
    }

    public static ServerLifecycleListener start(Runnable onStart) {
        return ServerLifecycleListener.wrap(onStart, null);
    }

    public static ServerLifecycleListener wrap(final @Nullable Runnable onStart, final @Nullable Runnable onStop) {
        return new ServerLifecycleListener(){

            @Override
            public void onServerStart() {
                if (onStart != null) {
                    onStart.run();
                }
            }

            @Override
            public void onServerStop() {
                if (onStop != null) {
                    onStop.run();
                }
            }
        };
    }
}

