/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.lib.GameRulesAS;
import hellfirepvp.astralsorcery.common.util.MapStream;
import hellfirepvp.astralsorcery.common.util.NoOpTeleporter;
import hellfirepvp.astralsorcery.common.util.WRItemObject;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.util.TriConsumer;

public class MiscUtils {
    @Nullable
    public static <T> T getTileAt(IBlockReader world, BlockPos pos, Class<T> tileClass, boolean forceChunkLoad) {
        if (world == null || pos == null) {
            return null;
        }
        if (world instanceof IWorld && !((IWorld)world).func_72863_F().func_222865_a(new ChunkPos(pos)) && !forceChunkLoad) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (tileClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public static boolean canEntityTickAt(IWorld world, BlockPos pos) {
        ChunkPos chPos = new ChunkPos(pos);
        if (!world.func_72863_F().func_222865_a(chPos)) {
            return false;
        }
        if (world.func_201670_d() || !(world instanceof ServerWorld)) {
            return true;
        }
        ServerChunkProvider chunkProvider = ((ServerWorld)world).func_72863_F();
        return !chunkProvider.field_217237_a.func_219243_d(chPos);
    }

    public static List<BlockSnapshot> captureBlockChanges(World world, Runnable r) {
        world.captureBlockSnapshots = true;
        r.run();
        world.captureBlockSnapshots = false;
        List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
        world.capturedBlockSnapshots.clear();
        return blockSnapshots;
    }

    @Nullable
    public static <T> T getRandomEntry(Collection<T> collection, Random rand) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int index = rand.nextInt(collection.size());
        return (T)Iterables.get(collection, (int)index);
    }

    @Nullable
    public static <T> T getRandomEntry(T[] array, Random rand) {
        if (array == null || array.length <= 0) {
            return null;
        }
        return array[rand.nextInt(array.length)];
    }

    @Nullable
    public static ModContainer getCurrentlyActiveMod() {
        return ModLoadingContext.get().getActiveContainer();
    }

    @Nonnull
    public static <T> T getEnumEntry(Class<T> enumClazz, int index) {
        if (!enumClazz.isEnum()) {
            throw new IllegalArgumentException("Called getEnumEntry on class " + enumClazz.getName() + " which isn't an enum.");
        }
        T[] values = enumClazz.getEnumConstants();
        if (values.length == 0) {
            throw new IllegalArgumentException(enumClazz.getName() + " has no enum constants.");
        }
        return values[MathHelper.func_76125_a((int)index, (int)0, (int)(values.length - 1))];
    }

    @Nullable
    public static <T> T getWeightedRandomEntry(Collection<T> list, Random rand, Function<T, Integer> getWeightFunction) {
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<WRItemObject<T>> weightedItems = new ArrayList<WRItemObject<T>>(list.size());
        for (T e : list) {
            weightedItems.add(new WRItemObject<T>(getWeightFunction.apply(e), e));
        }
        WRItemObject item = (WRItemObject)WeightedRandom.func_76271_a((Random)rand, weightedItems);
        return item != null ? (T)item.getValue() : null;
    }

    public static <T, V extends Comparable<V>> V getMaxEntry(Collection<T> elements, Function<T, V> valueFunction) {
        return MiscUtils.getMaxEntry(MiscUtils.transformCollection(elements, valueFunction));
    }

    public static <T extends Comparable<T>> T getMaxEntry(Collection<T> elements) {
        Comparable maxElement = null;
        for (Comparable element : elements) {
            if (maxElement != null && maxElement.compareTo(element) >= 0) continue;
            maxElement = element;
        }
        return (T)maxElement;
    }

    public static <T, V extends Comparable<V>> V getMinEntry(Collection<T> elements, Function<T, V> valueFunction) {
        return MiscUtils.getMinEntry(MiscUtils.transformCollection(elements, valueFunction));
    }

    public static <T extends Comparable<T>> T getMinEntry(Collection<T> elements) {
        Comparable minElement = null;
        for (Comparable element : elements) {
            if (minElement != null && minElement.compareTo(element) <= 0) continue;
            minElement = element;
        }
        return (T)minElement;
    }

    public static boolean canSeeSky(World world, BlockPos at, boolean loadChunk, boolean defaultValue) {
        return MiscUtils.canSeeSky(world, at, loadChunk, false, defaultValue);
    }

    public static boolean canSeeSky(World world, BlockPos at, boolean loadChunk, boolean allowInNoSkyWorlds, boolean defaultValue) {
        if (world.func_82736_K().func_223586_b(GameRulesAS.IGNORE_SKYLIGHT_CHECK_RULE)) {
            return true;
        }
        if (allowInNoSkyWorlds && !world.func_230315_m_().func_218272_d()) {
            return true;
        }
        if (!loadChunk) {
            return MiscUtils.executeWithChunk((IWorldReader)world, at, () -> world.func_175710_j(at), defaultValue);
        }
        return world.func_175710_j(at);
    }

    public static <T> Runnable apply(Consumer<T> func, Supplier<T> supply) {
        return () -> func.accept(supply.get());
    }

    public static <T, U> Consumer<T> apply(BiConsumer<T, U> func, Supplier<U> supply) {
        return t -> func.accept(t, supply.get());
    }

    public static <T, U, V> BiConsumer<T, U> apply(TriConsumer<T, U, V> func, Supplier<V> supply) {
        return (t, u) -> func.accept(t, u, supply.get());
    }

    public static <T, R> Supplier<R> apply(Function<T, R> func, Supplier<T> supply) {
        return () -> func.apply(supply.get());
    }

    public static <T, P, R> Function<P, R> apply(BiFunction<T, P, R> func, Supplier<T> supply) {
        return p -> func.apply(supply.get(), p);
    }

    public static <T, V> Function<T, V> nullFunction(Runnable run) {
        return MiscUtils.nullFunction((T v) -> run.run());
    }

    public static <T, V> Function<T, V> nullFunction(Consumer<T> run) {
        return t -> {
            run.accept(t);
            return null;
        };
    }

    public static <T> Supplier<T> nullSupplier(Runnable run) {
        return () -> {
            run.run();
            return null;
        };
    }

    public static <T, V> List<V> transformList(List<T> list, Function<T, V> map) {
        return list.stream().map(map).collect(Collectors.toList());
    }

    public static <T, V> Set<V> transformSet(Set<T> list, Function<T, V> map) {
        return list.stream().map(map).collect(Collectors.toSet());
    }

    public static <T, V> Collection<V> transformCollection(Collection<T> list, Function<T, V> map) {
        return list.stream().map(map).collect(Collectors.toList());
    }

    public static <K, V, N> Map<K, N> remap(Map<K, V> map, Function<V, N> remapFct) {
        return MapStream.of(map).mapValue(remapFct).toMap();
    }

    public static <T> void mergeList(Collection<T> src, List<T> dst) {
        for (T element : src) {
            if (dst.contains(element)) continue;
            dst.add(element);
        }
    }

    public static <T> void cutList(Collection<? extends T> toRemove, List<T> from) {
        for (T element : toRemove) {
            from.remove(element);
        }
    }

    public static <T> List<T> copyList(List<T> list) {
        ArrayList l = new ArrayList(list.size());
        Collections.copy(l, list);
        return l;
    }

    public static <T> Set<T> copySet(Set<T> set) {
        HashSet<T> s = new HashSet<T>(set.size());
        s.addAll(set);
        return s;
    }

    @Nullable
    public static <T> T iterativeSearch(Collection<T> collection, Predicate<T> matchingFct) {
        for (T element : collection) {
            if (!matchingFct.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean contains(Collection<T> collection, Predicate<T> matchingFct) {
        return MiscUtils.iterativeSearch(collection, matchingFct) != null;
    }

    public static <T> boolean matchesAny(T element, Collection<Predicate<T>> tests) {
        for (Predicate<T> test : tests) {
            if (!test.test(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFluidBlock(BlockState state) {
        return state.func_177230_c() instanceof FlowingFluidBlock;
    }

    @Nullable
    public static Fluid tryGetFuild(BlockState state) {
        FluidState fluidState;
        if (!MiscUtils.isFluidBlock(state)) {
            return null;
        }
        if (state.func_177230_c() instanceof FlowingFluidBlock && !(fluidState = state.func_204520_s()).func_206888_e()) {
            return fluidState.func_206886_c();
        }
        return null;
    }

    public static boolean canPlayerAttackServer(@Nullable LivingEntity source, @Nonnull LivingEntity target) {
        if (!target.func_70089_S()) {
            return false;
        }
        if (target instanceof PlayerEntity) {
            PlayerEntity plTarget = (PlayerEntity)target;
            if (target.func_130014_f_() instanceof ServerWorld && target.func_130014_f_().func_73046_m() != null && target.func_130014_f_().func_73046_m().func_71219_W()) {
                return false;
            }
            if (plTarget.func_175149_v() || plTarget.func_184812_l_()) {
                return false;
            }
            if (source instanceof PlayerEntity && !((PlayerEntity)source).func_96122_a(plTarget)) {
                return false;
            }
        }
        return true;
    }

    public static boolean canPlayerBreakBlockPos(PlayerEntity player, BlockPos tryBreak) {
        BlockEvent.BreakEvent ev = new BlockEvent.BreakEvent(player.func_130014_f_(), tryBreak, player.func_130014_f_().func_180495_p(tryBreak), player);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return !ev.isCanceled();
    }

    public static boolean canPlayerPlaceBlockPos(PlayerEntity player, BlockState tryPlace, BlockPos pos, Direction againstSide) {
        World world = player.func_130014_f_();
        world.captureBlockSnapshots = true;
        world.func_175656_a(pos, tryPlace);
        world.captureBlockSnapshots = false;
        List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
        world.capturedBlockSnapshots.clear();
        boolean cancelPlacement = false;
        if (blockSnapshots.size() > 1) {
            cancelPlacement = ForgeEventFactory.onMultiBlockPlace((Entity)player, (List)blockSnapshots, (Direction)againstSide);
        } else if (blockSnapshots.size() == 1) {
            cancelPlacement = ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (Direction)againstSide);
        }
        for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
            world.restoringBlockSnapshots = true;
            blocksnapshot.restore(true, false);
            world.restoringBlockSnapshots = false;
        }
        return !cancelPlacement;
    }

    public static boolean isConnectionEstablished(ServerPlayerEntity player) {
        return player.field_71135_a != null && player.field_71135_a.field_147371_a != null && player.field_71135_a.field_147371_a.func_150724_d();
    }

    public static long getRandomWorldSeed(ISeedReader world) {
        return new Random(world.func_72905_C()).nextLong();
    }

    @Nullable
    public static Tuple<Hand, ItemStack> getMainOrOffHand(LivingEntity entity, Item search) {
        return MiscUtils.getMainOrOffHand(entity, (ItemStack stack) -> !stack.func_190926_b() && stack.func_77973_b().equals(search));
    }

    @Nullable
    public static Tuple<Hand, ItemStack> getMainOrOffHand(LivingEntity entity, Predicate<ItemStack> acceptorFnc) {
        Hand hand = Hand.MAIN_HAND;
        ItemStack held = entity.func_184586_b(hand);
        if (held.func_190926_b() || !acceptorFnc.test(held)) {
            hand = Hand.OFF_HAND;
            held = entity.func_184586_b(hand);
        }
        if (held.func_190926_b() || !acceptorFnc.test(held)) {
            return null;
        }
        return new Tuple((Object)hand, (Object)held);
    }

    public static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    @Nullable
    public static <T extends Entity> T transferEntityTo(T entity, RegistryKey<World> target, BlockPos targetPos) {
        if (entity.func_130014_f_().field_72995_K) {
            return null;
        }
        entity.func_226284_e_(false);
        RegistryKey src = entity.func_130014_f_().func_234923_W_();
        if (!src.equals(target)) {
            if (!ForgeHooks.onTravelToDimension(entity, target)) {
                return null;
            }
            MinecraftServer srv = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            ServerWorld targetWorld = srv.func_71218_a(target);
            if (targetWorld == null) {
                return null;
            }
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).func_200619_a(targetWorld, (double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.1, (double)targetPos.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            } else if ((entity = entity.changeDimension(targetWorld, (ITeleporter)new NoOpTeleporter(targetWorld, targetPos))) == null) {
                return null;
            }
        }
        entity.func_70634_a((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p() + 0.5);
        return entity;
    }

    @Nullable
    public static BlockPos itDownTopBlock(World world, BlockPos at) {
        IChunk chunk = world.func_217349_x(at);
        BlockPos downPos = null;
        BlockPos blockpos = new BlockPos(at.func_177958_n(), chunk.func_76625_h() + 16, at.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            downPos = blockpos.func_177977_b();
            BlockState test = world.func_180495_p(downPos);
            if (!world.func_175623_d(downPos) && !test.func_235714_a_((ITag)BlockTags.field_206952_E) && test.func_224755_d((IBlockReader)world, downPos, Direction.UP)) break;
            blockpos = downPos;
        }
        return downPos;
    }

    public static List<Vector3> getCirclePositions(Vector3 centerOffset, Vector3 axis, double radius, int amountOfPointsOnCircle) {
        LinkedList<Vector3> out = new LinkedList<Vector3>();
        Vector3 circleVec = axis.clone().perpendicular().normalize().multiply(radius);
        double degPerPoint = 360.0 / (double)amountOfPointsOnCircle;
        for (int i = 0; i < amountOfPointsOnCircle; ++i) {
            double deg = (double)i * degPerPoint;
            out.add(circleVec.clone().rotate(Math.toRadians(deg), axis.clone()).add(centerOffset));
        }
        return out;
    }

    public static Vector3 getRandomCirclePosition(Vector3 centerOffset, Vector3 axis, double radius) {
        return MiscUtils.getCirclePosition(centerOffset, axis, radius, Math.random() * 360.0);
    }

    public static Vector3 getCirclePosition(Vector3 centerOffset, Vector3 axis, double radius, double degree) {
        Vector3 circleVec = axis.clone().perpendicular().normalize().multiply(radius);
        return circleVec.rotate(Math.toRadians(degree), axis.clone()).add(centerOffset);
    }

    @Nullable
    public static BlockRayTraceResult rayTraceLookBlock(PlayerEntity player) {
        return MiscUtils.rayTraceLookBlock(player, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e());
    }

    @Nonnull
    public static RayTraceResult rayTraceLook(PlayerEntity player) {
        return MiscUtils.rayTraceLook(player, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e());
    }

    @Nullable
    public static BlockRayTraceResult rayTraceLookBlock(PlayerEntity player, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        return MiscUtils.rayTraceLookBlock((Entity)player, blockMode, fluidMode, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e());
    }

    @Nonnull
    public static RayTraceResult rayTraceLook(PlayerEntity player, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        return MiscUtils.rayTraceLook((Entity)player, blockMode, fluidMode, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e());
    }

    @Nullable
    public static BlockRayTraceResult rayTraceLookBlock(PlayerEntity player, double reachDst) {
        return MiscUtils.rayTraceLookBlock((Entity)player, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, reachDst);
    }

    @Nonnull
    public static RayTraceResult rayTraceLook(PlayerEntity player, double reachDst) {
        return MiscUtils.rayTraceLook((Entity)player, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, reachDst);
    }

    @Nullable
    public static BlockRayTraceResult rayTraceLookBlock(Entity entity, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, double reachDst) {
        RayTraceResult rtr = MiscUtils.rayTraceLook(entity, blockMode, fluidMode, reachDst);
        if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK && rtr instanceof BlockRayTraceResult) {
            return (BlockRayTraceResult)rtr;
        }
        return null;
    }

    @Nonnull
    public static RayTraceResult rayTraceLook(Entity entity, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode, double reachDst) {
        Vector3d pos = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vector3d lookVec = entity.func_70040_Z();
        Vector3d end = pos.func_72441_c(lookVec.field_72450_a * reachDst, lookVec.field_72448_b * reachDst, lookVec.field_72449_c * reachDst);
        RayTraceContext ctx = new RayTraceContext(pos, end, blockMode, fluidMode, entity);
        return entity.field_70170_p.func_217299_a(ctx);
    }

    public static Color calcRandomConstellationColor(float perc) {
        return new Color(Color.HSBtoRGB((230.0f + 50.0f * perc) / 360.0f, 0.8f, 0.8f - 0.3f * perc));
    }

    public static void applyRandomOffset(Vector3 target, Random rand) {
        MiscUtils.applyRandomOffset(target, rand, 1.0f);
    }

    public static void applyRandomOffset(Vector3 target, Random rand, float multiplier) {
        target.addX(rand.nextFloat() * multiplier * (float)(rand.nextBoolean() ? 1 : -1));
        target.addY(rand.nextFloat() * multiplier * (float)(rand.nextBoolean() ? 1 : -1));
        target.addZ(rand.nextFloat() * multiplier * (float)(rand.nextBoolean() ? 1 : -1));
    }

    public static void applyRandomCircularOffset(Vector3 target, Random rand) {
        MiscUtils.applyRandomOffset(target, rand, 1.0f);
    }

    public static void applyRandomCircularOffset(Vector3 target, Random rand, float multiplier) {
        Vector3 v = Vector3.random().normalize().multiply(rand.nextFloat() * multiplier);
        target.addX(v.getX() * (double)(rand.nextBoolean() ? 1 : -1));
        target.addY(v.getY() * (double)(rand.nextBoolean() ? 1 : -1));
        target.addZ(v.getZ() * (double)(rand.nextBoolean() ? 1 : -1));
    }

    public static void executeWithChunk(IWorldReader world, ChunkPos pos, Runnable run) {
        MiscUtils.executeWithChunk(world, pos.func_206849_h(), MiscUtils.nullSupplier(run));
    }

    public static void executeWithChunk(IWorldReader world, BlockPos pos, Runnable run) {
        MiscUtils.executeWithChunk(world, pos, MiscUtils.nullSupplier(run));
    }

    public static <T> T executeWithChunk(IWorldReader world, BlockPos pos, Supplier<T> run) {
        return MiscUtils.executeWithChunk(world, pos, run, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithChunk(IWorldReader world, BlockPos pos, Supplier<T> run, T defaultValue) {
        block7: {
            AbstractChunkProvider provider;
            if (world instanceof ServerWorld && LogCategory.UNINTENDED_CHUNK_LOADING.isEnabled()) {
                ServerChunkProvider provider2 = ((ServerWorld)world).func_72863_F();
                int prev = provider2.func_73152_e();
                try {
                    if (provider2.func_222865_a(new ChunkPos(pos))) {
                        T t = run.get();
                        return t;
                    }
                    break block7;
                }
                finally {
                    int current = ((ServerWorld)world).func_72863_F().func_73152_e();
                    if (current > prev) {
                        AstralSorcery.log.warn("Astral Sorcery loaded a chunk when it intended not to!");
                        AstralSorcery.log.warn("Previous chunk count: " + prev);
                        AstralSorcery.log.warn("Current chunk count: " + current);
                        AstralSorcery.log.warn("Loaded " + (current - prev) + " chunks!");
                        AstralSorcery.log.warn("Stacktrace:", (Throwable)new Exception());
                    }
                }
            }
            if (world instanceof IWorld ? (provider = ((IWorld)world).func_72863_F()).func_222865_a(new ChunkPos(pos)) : world.func_175667_e(pos)) {
                return run.get();
            }
        }
        return defaultValue;
    }

    public static <T> void executeWithChunk(IWorldReader world, BlockPos pos, T obj, Consumer<T> run) {
        MiscUtils.executeWithChunk(world, pos, MiscUtils.nullSupplier(MiscUtils.apply(run, () -> obj)));
    }

    public static <T, U> void executeWithChunk(IWorldReader world, BlockPos pos, T obj, U obj1, BiConsumer<T, U> run) {
        MiscUtils.executeWithChunk(world, pos, obj, MiscUtils.apply(run, () -> obj1));
    }

    public static <T, R> R executeWithChunk(IWorldReader world, BlockPos pos, T obj, Function<T, R> run) {
        return MiscUtils.executeWithChunk(world, pos, MiscUtils.apply(run, () -> obj));
    }

    public static <T, R> R executeWithChunk(IWorldReader world, BlockPos pos, T obj, Function<T, R> run, R _default) {
        return MiscUtils.executeWithChunk(world, pos, MiscUtils.apply(run, () -> obj), _default);
    }

    public static <T> Function<T, T> mapWithChunk(IWorldReader world, Function<T, BlockPos> posFn) {
        return val -> MiscUtils.executeWithChunk(world, (BlockPos)posFn.apply(val), val, Function.identity());
    }

    public static <T> T eitherOf(Random r, T ... selection) {
        if (selection.length == 0) {
            return null;
        }
        return selection[r.nextInt(selection.length)];
    }

    public static <T> T eitherOf(Random r, Supplier<T> ... selection) {
        if (selection.length == 0) {
            return null;
        }
        return selection[r.nextInt(selection.length)].get();
    }

    public static <T> Optional<T> tryMultiple(Supplier<T> ... suppliers) {
        for (Supplier<T> supplier : suppliers) {
            try {
                return Optional.ofNullable(supplier.get());
            }
            catch (Exception exc) {
                AstralSorcery.log.error((Object)exc);
            }
        }
        return Optional.empty();
    }

    public static boolean isPlayerFakeMP(ServerPlayerEntity player) {
        if (player instanceof FakePlayer) {
            return true;
        }
        boolean isModdedPlayer = false;
        for (Mods mod : Mods.values()) {
            Class<?> specificPlayerClass;
            if (!mod.isPresent() || (specificPlayerClass = mod.getExtendedPlayerClass()) == null || player.getClass() == ServerPlayerEntity.class || player.getClass() != specificPlayerClass) continue;
            isModdedPlayer = true;
            break;
        }
        if (!isModdedPlayer && player.getClass() != ServerPlayerEntity.class) {
            return true;
        }
        if (player.field_71135_a == null) {
            return true;
        }
        try {
            player.func_71114_r().length();
            player.field_71135_a.field_147371_a.func_74430_c().toString();
        }
        catch (Exception exc) {
            return true;
        }
        return false;
    }
}

