/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;

public class MapStream<K, V>
implements Stream<Tuple<K, V>> {
    private final Stream<Tuple<K, V>> decorated;

    private MapStream(Stream<Tuple<K, V>> decorated) {
        this.decorated = decorated;
    }

    public static <K, V> MapStream<K, V> of(Map<K, V> map) {
        return new MapStream<K, V>(map.entrySet().stream().map((? super T e) -> new Tuple(e.getKey(), e.getValue())));
    }

    public static <K, V> MapStream<K, V> of(Collection<Tuple<K, V>> tplCollection) {
        return new MapStream<K, V>(tplCollection.stream());
    }

    public static <K, V> MapStream<K, V> of(Stream<Tuple<K, V>> tplStream) {
        return new MapStream<K, V>(tplStream);
    }

    public static <K, V> MapStream<K, V> ofKeys(Collection<K> collection, Function<K, V> valueProvider) {
        return MapStream.ofKeys(collection.stream(), valueProvider);
    }

    public static <K, V> MapStream<K, V> ofKeys(Stream<K> stream, Function<K, V> valueProvider) {
        return new MapStream<K, V>(stream.map((? super T k) -> new Tuple(k, valueProvider.apply(k))));
    }

    public static <K, V> MapStream<K, V> ofValues(Collection<V> collection, Function<V, K> keyProvider) {
        return MapStream.ofValues(collection.stream(), keyProvider);
    }

    public static <K, V> MapStream<K, V> ofValues(Stream<V> stream, Function<V, K> keyProvider) {
        return new MapStream<K, V>(stream.map((? super T v) -> new Tuple(keyProvider.apply(v), v)));
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<K, V> forEachFn) {
        MapStream.of(map).forEach((Consumer<Tuple<K, V>>)((Consumer<Tuple>)tpl -> forEachFn.accept(tpl.func_76341_a(), tpl.func_76340_b())));
    }

    public Map<K, V> toMap() {
        return this.decorated.collect(Collectors.toMap(Tuple::func_76341_a, Tuple::func_76340_b));
    }

    public <R> List<R> toList(BiFunction<K, V, R> flatFunction) {
        return this.decorated.map((? super T tpl) -> flatFunction.apply(tpl.func_76341_a(), tpl.func_76340_b())).collect(Collectors.toList());
    }

    public List<Tuple<K, V>> toTupleList() {
        return this.decorated.collect(Collectors.toList());
    }

    public <R> MapStream<K, R> mapValue(Function<V, R> valueMapper) {
        return MapStream.of(this.decorated.map((? super T tpl) -> new Tuple(tpl.func_76341_a(), valueMapper.apply(tpl.func_76340_b()))));
    }

    public <R> MapStream<R, V> mapKey(Function<K, R> keyMapper) {
        return MapStream.of(this.decorated.map((? super T tpl) -> new Tuple(keyMapper.apply(tpl.func_76341_a()), tpl.func_76340_b())));
    }

    public <R> Stream<R> flatten(BiFunction<K, V, R> flatFunction) {
        return this.decorated.map((? super T tpl) -> flatFunction.apply(tpl.func_76341_a(), tpl.func_76340_b()));
    }

    public MapStream<K, V> filterKey(Predicate<K> predicate) {
        return MapStream.of(this.decorated.filter((? super T tpl) -> predicate.test(tpl.func_76341_a())));
    }

    public MapStream<K, V> filterValue(Predicate<V> predicate) {
        return MapStream.of(this.decorated.filter((? super T tpl) -> predicate.test(tpl.func_76340_b())));
    }

    public Stream<V> valueStream() {
        return this.decorated.map(Tuple::func_76340_b);
    }

    public Stream<K> keyStream() {
        return this.decorated.map(Tuple::func_76341_a);
    }

    @Override
    public Stream<Tuple<K, V>> filter(Predicate<? super Tuple<K, V>> predicate) {
        return this.decorated.filter(predicate);
    }

    @Override
    public <R> Stream<R> map(Function<? super Tuple<K, V>, ? extends R> mapper) {
        return this.decorated.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super Tuple<K, V>> mapper) {
        return this.decorated.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super Tuple<K, V>> mapper) {
        return this.decorated.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super Tuple<K, V>> mapper) {
        return this.decorated.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super Tuple<K, V>, ? extends Stream<? extends R>> mapper) {
        return this.decorated.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super Tuple<K, V>, ? extends IntStream> mapper) {
        return this.decorated.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super Tuple<K, V>, ? extends LongStream> mapper) {
        return this.decorated.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super Tuple<K, V>, ? extends DoubleStream> mapper) {
        return this.decorated.flatMapToDouble(mapper);
    }

    @Override
    public Stream<Tuple<K, V>> distinct() {
        return this.decorated.distinct();
    }

    @Override
    public Stream<Tuple<K, V>> sorted() {
        return this.decorated.sorted();
    }

    @Override
    public Stream<Tuple<K, V>> sorted(Comparator<? super Tuple<K, V>> comparator) {
        return this.decorated.sorted(comparator);
    }

    @Override
    public Stream<Tuple<K, V>> peek(Consumer<? super Tuple<K, V>> action) {
        return this.decorated.peek(action);
    }

    @Override
    public Stream<Tuple<K, V>> limit(long maxSize) {
        return this.decorated.limit(maxSize);
    }

    @Override
    public Stream<Tuple<K, V>> skip(long n) {
        return this.decorated.skip(n);
    }

    @Override
    public void forEach(Consumer<? super Tuple<K, V>> action) {
        this.decorated.forEach(action);
    }

    public void forEach(BiConsumer<K, V> forEachFn) {
        this.decorated.forEach((? super T tpl) -> forEachFn.accept(tpl.func_76341_a(), tpl.func_76340_b()));
    }

    @Override
    public void forEachOrdered(Consumer<? super Tuple<K, V>> action) {
        this.decorated.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.decorated.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.decorated.toArray(generator);
    }

    @Override
    public Tuple<K, V> reduce(Tuple<K, V> identity, BinaryOperator<Tuple<K, V>> accumulator) {
        return this.decorated.reduce(identity, accumulator);
    }

    @Override
    public Optional<Tuple<K, V>> reduce(BinaryOperator<Tuple<K, V>> accumulator) {
        return this.decorated.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super Tuple<K, V>, U> accumulator, BinaryOperator<U> combiner) {
        return this.decorated.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super Tuple<K, V>> accumulator, BiConsumer<R, R> combiner) {
        return this.decorated.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super Tuple<K, V>, A, R> collector) {
        return this.decorated.collect(collector);
    }

    @Override
    public Optional<Tuple<K, V>> min(Comparator<? super Tuple<K, V>> comparator) {
        return this.decorated.min(comparator);
    }

    @Override
    public Optional<Tuple<K, V>> max(Comparator<? super Tuple<K, V>> comparator) {
        return this.decorated.max(comparator);
    }

    @Override
    public long count() {
        return this.decorated.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super Tuple<K, V>> predicate) {
        return this.decorated.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super Tuple<K, V>> predicate) {
        return this.decorated.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super Tuple<K, V>> predicate) {
        return this.decorated.noneMatch(predicate);
    }

    @Override
    public Optional<Tuple<K, V>> findFirst() {
        return this.decorated.findFirst();
    }

    @Override
    public Optional<Tuple<K, V>> findAny() {
        return this.decorated.findAny();
    }

    @Override
    public Iterator<Tuple<K, V>> iterator() {
        return this.decorated.iterator();
    }

    @Override
    public Spliterator<Tuple<K, V>> spliterator() {
        return this.decorated.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.decorated.isParallel();
    }

    @Override
    public Stream<Tuple<K, V>> sequential() {
        return (Stream)this.decorated.sequential();
    }

    @Override
    public Stream<Tuple<K, V>> parallel() {
        return (Stream)this.decorated.parallel();
    }

    @Override
    public Stream<Tuple<K, V>> unordered() {
        return (Stream)this.decorated.unordered();
    }

    @Override
    public Stream<Tuple<K, V>> onClose(Runnable closeHandler) {
        return (Stream)this.decorated.onClose(closeHandler);
    }

    @Override
    public void close() {
        this.decorated.close();
    }
}

