/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.storage.StorageKey;
import hellfirepvp.astralsorcery.common.storage.StoredItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.IItemHandler;

public class StorageCache {
    private final Map<StorageKey, List<StoredItemStack>> content = Maps.newHashMap();

    public int getTotalItemCount() {
        int i = 0;
        for (List<StoredItemStack> stacks : this.content.values()) {
            for (StoredItemStack stack : stacks) {
                i += stack.getAmount();
            }
        }
        return i;
    }

    public int getItemCount(StorageKey key) {
        int i = 0;
        for (StoredItemStack s : this.content.getOrDefault(key, Lists.newArrayList())) {
            i += s.getAmount();
        }
        return i;
    }

    public boolean add(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        StorageKey key = StorageKey.from(stack);
        for (StoredItemStack s : this.content.computeIfAbsent(key, stKey -> Lists.newArrayList())) {
            if (!s.combineIntoThis(stack)) continue;
            return true;
        }
        this.content.get(key).add(new StoredItemStack(stack));
        return true;
    }

    private void mergeIntoThis(StorageCache otherStorage) {
        for (StorageKey otherKey : otherStorage.content.keySet()) {
            List thisStorage = this.content.computeIfAbsent(otherKey, stKey -> Lists.newArrayList());
            ArrayList notMerged = Lists.newArrayList();
            block1: for (StoredItemStack toMerge : otherStorage.content.get(otherKey)) {
                for (StoredItemStack thisItem : thisStorage) {
                    if (!thisItem.combineIntoThis(toMerge)) continue;
                    continue block1;
                }
                notMerged.add(toMerge);
            }
            thisStorage.addAll(notMerged);
        }
    }

    public boolean attemptTransferInto(StorageKey key, IItemHandler inv, int slot, boolean simulate) {
        if (this.content.isEmpty()) {
            return false;
        }
        List<StoredItemStack> stacks = this.content.get(key);
        if (stacks == null || stacks.isEmpty()) {
            return false;
        }
        for (StoredItemStack stack : stacks) {
            ItemStack notInserted;
            ItemStack sample = stack.getTemplateStack();
            int amountToRemove = sample.func_190916_E();
            int addedCount = amountToRemove - (notInserted = inv.insertItem(slot, sample, simulate)).func_190916_E();
            if (addedCount <= 0) continue;
            if (!simulate) {
                if (!stack.removeAmount(addedCount)) {
                    return false;
                }
                if (stack.isEmpty()) {
                    stacks.remove(stack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean attemptTransferInto(StorageKey key, IItemHandler inv, boolean simulate) {
        if (this.content.isEmpty()) {
            return false;
        }
        List<StoredItemStack> stacks = this.content.get(key);
        if (stacks == null || stacks.isEmpty()) {
            return false;
        }
        boolean change = false;
        block0: for (int i = 0; i < inv.getSlots(); ++i) {
            for (StoredItemStack stack : stacks) {
                ItemStack notInserted;
                ItemStack sample = stack.getTemplateStack();
                int amountToRemove = sample.func_190916_E();
                int addedCount = amountToRemove - (notInserted = inv.insertItem(i, sample, simulate)).func_190916_E();
                if (addedCount > 0) {
                    change = true;
                }
                if (simulate) continue;
                if (!stack.removeAmount(addedCount)) {
                    return false;
                }
                if (!stack.isEmpty()) continue;
                stacks.remove(stack);
                continue block0;
            }
        }
        return change;
    }

    public void writeToNBT(CompoundNBT tag) {
        ListNBT content = new ListNBT();
        for (StorageKey key : this.content.keySet()) {
            CompoundNBT itemStorage = new CompoundNBT();
            itemStorage.func_218657_a("storageKey", (INBT)key.serialize());
            ListNBT items = new ListNBT();
            for (StoredItemStack stack : this.content.get(key)) {
                items.add((Object)stack.serialize());
            }
            itemStorage.func_218657_a("items", (INBT)items);
        }
        tag.func_218657_a("content", (INBT)content);
    }

    public void readFromNBT(CompoundNBT tag) {
        this.content.clear();
        ListNBT content = tag.func_150295_c("content", 10);
        for (int i = 0; i < content.size(); ++i) {
            CompoundNBT itemStorage = content.func_150305_b(i);
            StorageKey key = StorageKey.deserialize(itemStorage.func_74775_l("storageKey"));
            if (key == null) continue;
            ListNBT items = itemStorage.func_150295_c("items", 10);
            ArrayList<StoredItemStack> stacks = new ArrayList<StoredItemStack>(items.size());
            for (int j = 0; j < items.size(); ++j) {
                StoredItemStack stack = StoredItemStack.deserialize(items.func_150305_b(j));
                if (stack == null) continue;
                stacks.add(stack);
            }
            this.content.put(key, stacks);
        }
    }
}

