/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityEmpty;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityGrapplingHook;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntityItemHighlighted;
import hellfirepvp.astralsorcery.client.render.entity.RenderEntitySpectralTool;
import hellfirepvp.astralsorcery.common.entity.EntityFlare;
import hellfirepvp.astralsorcery.common.entity.EntityIlluminationSpark;
import hellfirepvp.astralsorcery.common.entity.EntityNocturnalSpark;
import hellfirepvp.astralsorcery.common.entity.EntitySpectralTool;
import hellfirepvp.astralsorcery.common.entity.item.EntityCrystal;
import hellfirepvp.astralsorcery.common.entity.item.EntityItemExplosionResistant;
import hellfirepvp.astralsorcery.common.entity.item.EntityItemHighlighted;
import hellfirepvp.astralsorcery.common.entity.item.EntityStarmetal;
import hellfirepvp.astralsorcery.common.entity.technical.EntityGrapplingHook;
import hellfirepvp.astralsorcery.common.entity.technical.EntityObservatoryHelper;
import hellfirepvp.astralsorcery.common.lib.EntityTypesAS;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class RegistryEntities {
    private RegistryEntities() {
    }

    public static void init() {
        EntityTypesAS.NOCTURNAL_SPARK = RegistryEntities.register("nocturnal_spark", EntityType.Builder.func_220322_a(EntityNocturnalSpark.factory(), (EntityClassification)EntityClassification.MISC).func_200705_b().func_220320_c().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setCustomClientFactory((spawnEntity, world) -> new EntityNocturnalSpark((World)world)).func_220321_a(0.1f, 0.1f));
        EntityTypesAS.ILLUMINATION_SPARK = RegistryEntities.register("illumination_spark", EntityType.Builder.func_220322_a(EntityIlluminationSpark.factory(), (EntityClassification)EntityClassification.MISC).func_200705_b().func_220320_c().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setCustomClientFactory((spawnEntity, world) -> new EntityIlluminationSpark((World)world)).func_220321_a(0.1f, 0.1f));
        EntityTypesAS.FLARE = RegistryEntities.register("flare", EntityType.Builder.func_220322_a(EntityFlare.factory(), (EntityClassification)EntityClassification.MISC).func_220320_c().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setCustomClientFactory((spawnEntity, world) -> new EntityFlare((World)world)).func_220321_a(0.4f, 0.4f));
        EntityTypesAS.SPECTRAL_TOOL = RegistryEntities.register("spectral_tool", EntityType.Builder.func_220322_a(EntitySpectralTool.factory(), (EntityClassification)EntityClassification.MISC).func_200705_b().func_220320_c().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).setCustomClientFactory((spawnEntity, world) -> new EntitySpectralTool((World)world)).func_220321_a(0.6f, 0.8f));
        EntityTypesAS.ITEM_HIGHLIGHT = RegistryEntities.register("item_highlighted", EntityType.Builder.func_220322_a(EntityItemHighlighted.factoryHighlighted(), (EntityClassification)EntityClassification.MISC).func_200705_b().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setCustomClientFactory((spawnEntity, world) -> new EntityItemHighlighted((EntityType<? extends ItemEntity>)EntityTypesAS.ITEM_HIGHLIGHT, (World)world)).func_220321_a(0.25f, 0.25f));
        EntityTypesAS.ITEM_EXPLOSION_RESISTANT = RegistryEntities.register("item_explosion_resistant", EntityType.Builder.func_220322_a(EntityItemExplosionResistant.factoryExplosionResistant(), (EntityClassification)EntityClassification.MISC).func_200705_b().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setCustomClientFactory((spawnEntity, world) -> new EntityItemExplosionResistant((EntityType<? extends ItemEntity>)EntityTypesAS.ITEM_EXPLOSION_RESISTANT, (World)world)).func_220321_a(0.25f, 0.25f));
        EntityTypesAS.ITEM_CRYSTAL = RegistryEntities.register("item_crystal", EntityType.Builder.func_220322_a(EntityCrystal.factoryCrystal(), (EntityClassification)EntityClassification.MISC).func_200705_b().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setCustomClientFactory((spawnEntity, world) -> new EntityCrystal((EntityType<? extends ItemEntity>)EntityTypesAS.ITEM_CRYSTAL, (World)world)).func_220321_a(0.5f, 0.5f));
        EntityTypesAS.ITEM_STARMETAL_INGOT = RegistryEntities.register("item_starmetal", EntityType.Builder.func_220322_a(EntityStarmetal.factoryStarmetalIngot(), (EntityClassification)EntityClassification.MISC).func_200705_b().setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setTrackingRange(16).setCustomClientFactory((spawnEntity, world) -> new EntityStarmetal((EntityType<? extends ItemEntity>)EntityTypesAS.ITEM_STARMETAL_INGOT, (World)world)).func_220321_a(0.5f, 0.5f));
        EntityTypesAS.OBSERVATORY_HELPER = RegistryEntities.register("observatory_helper", EntityType.Builder.func_220322_a(EntityObservatoryHelper.factory(), (EntityClassification)EntityClassification.MISC).func_200705_b().setUpdateInterval(1).func_220320_c().setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setCustomClientFactory((spawnEntity, world) -> new EntityObservatoryHelper((World)world)).func_220321_a(0.0f, 0.0f));
        EntityTypesAS.GRAPPLING_HOOK = RegistryEntities.register("grappling_hook", EntityType.Builder.func_220322_a(EntityGrapplingHook.factory(), (EntityClassification)EntityClassification.MISC).func_200705_b().setUpdateInterval(1).func_220320_c().setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setCustomClientFactory((spawnEntity, world) -> new EntityGrapplingHook((World)world)).func_220321_a(0.1f, 0.1f));
    }

    public static void initAttributes() {
        GlobalEntityTypeAttributes.put(EntityTypesAS.FLARE, (AttributeModifierMap)EntityFlare.createAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(EntityTypesAS.SPECTRAL_TOOL, (AttributeModifierMap)EntitySpectralTool.createAttributes().func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.NOCTURNAL_SPARK, (IRenderFactory)new RenderEntityEmpty.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.ILLUMINATION_SPARK, (IRenderFactory)new RenderEntityEmpty.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.FLARE, (IRenderFactory)new RenderEntityEmpty.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.SPECTRAL_TOOL, (IRenderFactory)new RenderEntitySpectralTool.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.ITEM_HIGHLIGHT, (IRenderFactory)new RenderEntityItemHighlighted.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.ITEM_EXPLOSION_RESISTANT, (IRenderFactory)new RenderEntityItemHighlighted.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.ITEM_CRYSTAL, (IRenderFactory)new RenderEntityItemHighlighted.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.ITEM_STARMETAL_INGOT, manager -> new ItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.OBSERVATORY_HELPER, (IRenderFactory)new RenderEntityEmpty.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityTypesAS.GRAPPLING_HOOK, (IRenderFactory)new RenderEntityGrapplingHook.Factory());
    }

    private static <E extends Entity> EntityType<E> register(String name, EntityType.Builder<E> typeBuilder) {
        EntityType type = typeBuilder.func_206830_a(AstralSorcery.key(name).toString());
        type.setRegistryName(AstralSorcery.key(name));
        AstralSorcery.getProxy().getRegistryPrimer().register(type);
        return type;
    }
}

