/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.root;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.util.DiminishingMultiplier;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class RootEvorsio
extends RootPerk {
    public static final RootPerk.Config CONFIG = new RootPerk.Config("root.evorsio");

    public RootEvorsio(ResourceLocation name, float x, float y) {
        super(name, CONFIG, ConstellationsAS.evorsio, x, y);
    }

    @Override
    @Nonnull
    protected DiminishingMultiplier createMultiplier() {
        return new DiminishingMultiplier(1000L, 0.1f, 0.005f, 0.15f);
    }

    @Override
    protected void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.LOWEST, this::onBreak);
    }

    private void onBreak(BlockEvent.BreakEvent event) {
        float gainedExp;
        PlayerEntity player = event.getPlayer();
        LogicalSide side = this.getSide((Entity)player);
        if (!side.isServer()) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (!prog.getPerkData().hasPerkEffect(this)) {
            return;
        }
        BlockState broken = event.getState();
        IWorld world = event.getWorld();
        try {
            gainedExp = broken.func_185887_b((IBlockReader)world, event.getPos());
        }
        catch (Exception exc) {
            gainedExp = 0.5f;
        }
        if (gainedExp < 0.0f) {
            return;
        }
        gainedExp *= 2.5f;
        gainedExp = (float)((double)gainedExp * this.getExpMultiplier());
        gainedExp *= this.getDiminishingReturns(player);
        gainedExp *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
        gainedExp *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP);
        gainedExp = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP, gainedExp);
        ResearchManager.modifyExp(player, gainedExp);
    }
}

