/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.root;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.util.DiminishingMultiplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class RootDiscidia
extends RootPerk {
    public static final RootPerk.Config CONFIG = new RootPerk.Config("root.discidia");

    public RootDiscidia(ResourceLocation name, float x, float y) {
        super(name, CONFIG, ConstellationsAS.discidia, x, y);
    }

    @Override
    @Nonnull
    protected DiminishingMultiplier createMultiplier() {
        return new DiminishingMultiplier(6000L, 0.075f, 0.025f, 0.15f);
    }

    @Override
    protected void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.LOWEST, this::onDamage);
    }

    private void onDamage(LivingDamageEvent event) {
        DamageSource ds = event.getSource();
        PlayerEntity player = null;
        if (ds.func_76364_f() != null && ds.func_76364_f() instanceof PlayerEntity) {
            player = (PlayerEntity)ds.func_76364_f();
        }
        if (player == null && ds.func_76346_g() != null && ds.func_76346_g() instanceof PlayerEntity) {
            player = (PlayerEntity)ds.func_76346_g();
        }
        if (player == null) {
            return;
        }
        LogicalSide side = this.getSide((Entity)player);
        if (!side.isServer()) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (!prog.getPerkData().hasPerkEffect(this)) {
            return;
        }
        float mul = 4.0f;
        CombatTracker combat = event.getEntityLiving().func_110142_aN();
        if (combat.field_94552_d && combat.func_180134_f() > 2400) {
            mul = 0.01f;
        }
        float expGain = Math.min(event.getAmount() * mul, 100.0f);
        expGain = (float)((double)expGain * this.getExpMultiplier());
        expGain *= this.getDiminishingReturns(player);
        expGain *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
        expGain *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP);
        expGain = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP, expGain);
        ResearchManager.modifyExp(player, expGain);
    }
}

