/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.root;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.RootPerk;
import hellfirepvp.astralsorcery.common.util.DiminishingMultiplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class RootAevitas
extends RootPerk {
    public static final RootPerk.Config CONFIG = new RootPerk.Config("root.aevitas");

    public RootAevitas(ResourceLocation name, float x, float y) {
        super(name, CONFIG, ConstellationsAS.aevitas, x, y);
    }

    @Override
    @Nonnull
    protected DiminishingMultiplier createMultiplier() {
        return new DiminishingMultiplier(600L, 1.0f, 1.0f, 0.01f);
    }

    @Override
    protected void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(this::onPlace);
    }

    private void onPlace(BlockEvent.EntityPlaceEvent event) {
        float hardness;
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        LogicalSide side = this.getSide((Entity)player);
        if (!side.isServer()) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        if (!prog.getPerkData().hasPerkEffect(this)) {
            return;
        }
        try {
            hardness = Math.max(event.getPlacedBlock().func_185887_b((IBlockReader)event.getWorld(), event.getPos()), 1.0f);
        }
        catch (Exception exc) {
            hardness = 1.0f;
        }
        float xp = Math.min(hardness * 6.0f, 100.0f);
        xp = (float)((double)xp * this.getExpMultiplier());
        xp *= this.getDiminishingReturns(player);
        xp *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
        xp *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP);
        xp = AttributeEvent.postProcessModded(player, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP, xp);
        ResearchManager.modifyExp(player, xp);
    }
}

