/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.config.registry.OreBlockRarityRegistry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import hellfirepvp.astralsorcery.common.perk.tick.PlayerTickPerk;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;

public class KeyStoneEnrichment
extends KeyPerk
implements PlayerTickPerk {
    private static final int defaultEnrichmentRadius = 3;
    private static final int defaultChanceToEnrich = 55;
    private static final int defaultChargeCost = 150;
    public static final Config CONFIG = new Config("key.stone_enrichment");

    public KeyStoneEnrichment(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void onPlayerTick(PlayerEntity player, LogicalSide side) {
        if (side.isServer()) {
            PlayerProgress prog = ResearchHelper.getProgress(player, side);
            float modChance = ((Integer)CONFIG.chanceToEnrich.get()).intValue();
            if (rand.nextInt(Math.round(Math.max(modChance /= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT), 1.0f))) == 0 && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), true)) {
                Block block;
                BlockPos pos;
                float radius = ((Integer)CONFIG.enrichmentRadius.get()).intValue();
                Vector3 vec = Vector3.atEntityCenter((Entity)player).add(rand.nextFloat() * (radius *= PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT)) * 2.0f - radius, rand.nextFloat() * radius * 2.0f - radius, rand.nextFloat() * radius * 2.0f - radius);
                World world = player.func_130014_f_();
                if (Tags.Blocks.STONE.func_230235_a_((Object)world.func_180495_p(pos = vec.toBlockPos()).func_177230_c()) && (block = OreBlockRarityRegistry.STONE_ENRICHMENT.getRandomBlock(rand)) != null && world.func_180501_a(pos, block.func_176223_P(), 11)) {
                    AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false);
                }
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.IntValue enrichmentRadius;
        private ForgeConfigSpec.IntValue chanceToEnrich;
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.enrichmentRadius = cfgBuilder.comment("Defines the radius where a random position to generate a ore at is checked for").translation(this.translationKey("enrichmentRadius")).defineInRange("enrichmentRadius", 3, 1, 15);
            this.chanceToEnrich = cfgBuilder.comment("Sets the chance (Random.nextInt(chance) == 0) to try to see if a random stone next to the player should get turned into an ore; the lower the more likely").translation(this.translationKey("chanceToEnrich")).defineInRange("chanceToEnrich", 55, 2, 512);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per created ore.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 150, 1, 500);
        }
    }
}

