/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import hellfirepvp.astralsorcery.common.data.config.entry.PerkConfig;
import hellfirepvp.astralsorcery.common.util.SidedReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PerkLevelManager {
    private static final SidedReference<LevelData> LEVEL_DATA = new SidedReference();

    private PerkLevelManager() {
    }

    public static void clearCache(LogicalSide side) {
        LEVEL_DATA.setData(side, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveLevelCap(int maxLevel) {
        LEVEL_DATA.setData(LogicalSide.CLIENT, new LevelData(maxLevel));
    }

    public static void loadPerkLevels() {
        LEVEL_DATA.setData(LogicalSide.SERVER, new LevelData((Integer)PerkConfig.CONFIG.perkLevelCap.get()));
    }

    public static int getLevel(double totalExp, PlayerEntity player, LogicalSide side) {
        return PerkLevelManager.getLevel(MathHelper.func_76124_d((double)totalExp), player, side);
    }

    private static int getLevel(long totalExp, PlayerEntity player, LogicalSide side) {
        if (totalExp <= 0L) {
            return 1;
        }
        int levelCap = PerkLevelManager.getLevelCap(side, player);
        return LEVEL_DATA.getData(side).map(data -> {
            for (int i = 1; i <= levelCap; ++i) {
                if (totalExp >= ((LevelData)data).totalExpLevelRequired.getOrDefault(i, Long.MAX_VALUE)) continue;
                return i;
            }
            return levelCap;
        }).orElse(1);
    }

    public static long getExpForLevel(int targetLevel, PlayerEntity player, LogicalSide side) {
        if (targetLevel <= 1) {
            return 0L;
        }
        int levelCap = PerkLevelManager.getLevelCap(side, player);
        return LEVEL_DATA.getData(side).map(data -> {
            int level = targetLevel;
            if (level > levelCap) {
                level = levelCap;
            }
            return (Long)((LevelData)data).totalExpLevelRequired.get(level);
        }).orElse(0L);
    }

    public static float getNextLevelPercent(double totalExp, PlayerEntity player, LogicalSide side) {
        int level = PerkLevelManager.getLevel(totalExp, player, side);
        if (level >= PerkLevelManager.getLevelCap(side, player)) {
            return 1.0f;
        }
        return LEVEL_DATA.getData(side).map(data -> {
            long nextLevel = ((LevelData)data).totalExpLevelRequired.getOrDefault(level, 0L);
            long prevLevel = ((LevelData)data).totalExpLevelRequired.getOrDefault(level - 1, 0L);
            return Float.valueOf((float)(totalExp - (double)prevLevel) / (float)(nextLevel - prevLevel));
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static int getLevelCap(LogicalSide side, @Nullable PlayerEntity player) {
        return LEVEL_DATA.getData(side).map(data -> ((LevelData)data).levelCap).orElse(1);
    }

    private static class LevelData {
        private final Map<Integer, Long> totalExpLevelRequired = new HashMap<Integer, Long>();
        private final int levelCap;

        public LevelData(int levelCap) {
            this.levelCap = levelCap;
            this.buildLevelRequirements();
        }

        private void buildLevelRequirements() {
            if (this.totalExpLevelRequired.isEmpty()) {
                for (int i = 1; i <= this.levelCap; ++i) {
                    long prev = this.totalExpLevelRequired.getOrDefault(i - 1, 0L);
                    this.totalExpLevelRequired.put(i, prev + 150L + 100L * (long)MathHelper.func_76128_c((double)Math.pow(1.2f, i)));
                }
            }
        }
    }
}

