/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.auxiliary.gateway.CelestialGatewayHandler;
import hellfirepvp.astralsorcery.common.data.world.GatewayCache;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktUpdateGateways
extends ASPacket<PktUpdateGateways> {
    private Map<RegistryKey<World>, Collection<GatewayCache.GatewayNode>> positions = new HashMap<RegistryKey<World>, Collection<GatewayCache.GatewayNode>>();

    public PktUpdateGateways() {
    }

    public PktUpdateGateways(Map<RegistryKey<World>, Collection<GatewayCache.GatewayNode>> positions) {
        this.positions = positions;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktUpdateGateways> encoder() {
        return (packet, buffer) -> {
            buffer.writeInt(packet.positions.size());
            for (RegistryKey<World> dim : packet.positions.keySet()) {
                ByteBufUtils.writeVanillaRegistryEntry(buffer, dim);
                ByteBufUtils.writeCollection(buffer, packet.positions.get(dim), (buf, node) -> node.write((PacketBuffer)buf));
            }
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktUpdateGateways> decoder() {
        return buffer -> {
            PktUpdateGateways pkt = new PktUpdateGateways();
            int dimSize = buffer.readInt();
            for (int i = 0; i < dimSize; ++i) {
                RegistryKey dim = ByteBufUtils.readVanillaRegistryEntry(buffer);
                pkt.positions.put(dim, ByteBufUtils.readList(buffer, GatewayCache.GatewayNode::read));
            }
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktUpdateGateways> handler() {
        return new ASPacket.Handler<PktUpdateGateways>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktUpdateGateways packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> CelestialGatewayHandler.INSTANCE.updateClientCache(packet.positions));
            }

            @Override
            public void handle(PktUpdateGateways packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

