/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncCharge
extends ASPacket<PktSyncCharge> {
    private float maxCharge = 0.0f;
    private float charge = 0.0f;

    public PktSyncCharge() {
    }

    private PktSyncCharge(float maxCharge, float charge) {
        this.maxCharge = maxCharge;
        this.charge = charge;
    }

    public PktSyncCharge(PlayerEntity player) {
        this.maxCharge = AlignmentChargeHandler.INSTANCE.getMaximumCharge(player, LogicalSide.SERVER);
        this.charge = AlignmentChargeHandler.INSTANCE.getCurrentCharge(player, LogicalSide.SERVER);
    }

    public float getMaxCharge() {
        return this.maxCharge;
    }

    public float getCharge() {
        return this.charge;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncCharge> encoder() {
        return (packet, buffer) -> {
            buffer.writeFloat(packet.maxCharge);
            buffer.writeFloat(packet.charge);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncCharge> decoder() {
        return buffer -> new PktSyncCharge(buffer.readFloat(), buffer.readFloat());
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncCharge> handler() {
        return new ASPacket.Handler<PktSyncCharge>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncCharge packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> AlignmentChargeHandler.INSTANCE.receiveCharge(packet, (PlayerEntity)Minecraft.func_71410_x().field_71439_g));
            }

            @Override
            public void handle(PktSyncCharge packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }
}

